/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.common;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public final class CopyOnFirstWriteList<E>
extends AbstractList<E>
implements List<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ReentrantLock lock = new ReentrantLock(false);
    private List<E> list;
    private volatile boolean copied = false;

    public CopyOnFirstWriteList(List<E> list) {
        this.list = list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.checkCopyOnWrite();
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.checkCopyOnWrite();
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.checkCopyOnWrite();
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkCopyOnWrite();
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkCopyOnWrite();
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkCopyOnWrite();
        return this.list.retainAll(c);
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        this.checkCopyOnWrite();
        this.list.replaceAll(operator);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        this.checkCopyOnWrite();
        return this.list.removeIf(filter);
    }

    @Override
    public void sort(Comparator<? super E> c) {
        this.checkCopyOnWrite();
        this.list.sort(c);
    }

    @Override
    public void clear() {
        if (!this.copied) {
            this.list = new ArrayList();
            this.copied = true;
        }
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        this.checkCopyOnWrite();
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.checkCopyOnWrite();
        this.list.add(index, element);
    }

    @Override
    public E remove(int index) {
        this.checkCopyOnWrite();
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    private void checkCopyOnWrite() {
        if (!this.copied) {
            this.lock.lock();
            try {
                if (!this.copied) {
                    this.list = new ArrayList<E>(this.list);
                    this.copied = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

