/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.ebean.ProfileLocation;
import io.ebean.annotation.PersistBatch;
import io.ebean.annotation.TxIsolation;
import io.ebean.annotation.TxType;
import java.util.ArrayList;

public final class TxScope {
    private int profileId;
    private TxType type;
    private String serverName;
    private TxIsolation isolation;
    private PersistBatch batch;
    private PersistBatch batchOnCascade;
    private int batchSize;
    private boolean skipGeneratedKeys;
    private boolean readOnly;
    private boolean flushOnQuery = true;
    private boolean skipCache;
    private String label;
    private ArrayList<Class<? extends Throwable>> rollbackFor;
    private ArrayList<Class<? extends Throwable>> noRollbackFor;
    private ProfileLocation profileLocation;

    public static TxScope required() {
        return new TxScope(TxType.REQUIRED);
    }

    public static TxScope requiresNew() {
        return new TxScope(TxType.REQUIRES_NEW);
    }

    public static TxScope mandatory() {
        return new TxScope(TxType.MANDATORY);
    }

    public static TxScope supports() {
        return new TxScope(TxType.SUPPORTS);
    }

    public static TxScope notSupported() {
        return new TxScope(TxType.NOT_SUPPORTED);
    }

    public static TxScope never() {
        return new TxScope(TxType.NEVER);
    }

    public TxScope() {
        this.type = TxType.REQUIRED;
    }

    public TxScope(TxType type) {
        this.type = type;
    }

    public String toString() {
        return "TxScope[" + this.type + "] readOnly[" + this.readOnly + "] isolation[" + this.isolation + "] serverName[" + this.serverName + "] rollbackFor[" + this.rollbackFor + "] noRollbackFor[" + this.noRollbackFor + "]";
    }

    public boolean isBatchSet() {
        return this.batch != null && this.batch != PersistBatch.INHERIT;
    }

    public boolean isBatchOnCascadeSet() {
        return this.batchOnCascade != null && this.batchOnCascade != PersistBatch.INHERIT;
    }

    public boolean isBatchSizeSet() {
        return this.batchSize > 0;
    }

    public void checkBatchMode() {
        if (this.batchSize > 0 && this.notSet(this.batch) && this.notSet(this.batchOnCascade)) {
            this.batch = PersistBatch.ALL;
        }
    }

    private boolean notSet(PersistBatch batchMode) {
        return batchMode == null || batchMode == PersistBatch.INHERIT;
    }

    public TxType getType() {
        return this.type;
    }

    public TxScope setType(TxType type) {
        this.type = type;
        return this;
    }

    public int getProfileId() {
        return this.profileId;
    }

    public TxScope setProfileId(int profileId) {
        this.profileId = profileId;
        return this;
    }

    public ProfileLocation getProfileLocation() {
        return this.profileLocation;
    }

    public TxScope setProfileLocation(ProfileLocation profileLocation) {
        this.profileLocation = profileLocation;
        return this;
    }

    public boolean isSkipCache() {
        return this.skipCache;
    }

    public TxScope setSkipCache(boolean skipCache) {
        this.skipCache = skipCache;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public TxScope setLabel(String label) {
        this.label = label;
        return this;
    }

    public PersistBatch getBatch() {
        return this.batch;
    }

    public TxScope setBatch(PersistBatch batch) {
        this.batch = batch;
        return this;
    }

    public PersistBatch getBatchOnCascade() {
        return this.batchOnCascade;
    }

    public TxScope setBatchOnCascade(PersistBatch batchOnCascade) {
        this.batchOnCascade = batchOnCascade;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public TxScope setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public TxScope setSkipGeneratedKeys() {
        this.skipGeneratedKeys = true;
        return this;
    }

    public boolean isSkipGeneratedKeys() {
        return this.skipGeneratedKeys;
    }

    public boolean isReadonly() {
        return this.readOnly;
    }

    public TxScope setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public boolean isFlushOnQuery() {
        return this.flushOnQuery;
    }

    public TxScope setFlushOnQuery(boolean flushOnQuery) {
        this.flushOnQuery = flushOnQuery;
        return this;
    }

    public int getIsolationLevel() {
        return this.isolation != null ? this.isolation.getLevel() : -1;
    }

    public TxIsolation getIsolation() {
        return this.isolation;
    }

    public TxScope setIsolation(TxIsolation isolation) {
        this.isolation = isolation;
        return this;
    }

    public String getServerName() {
        return this.serverName;
    }

    public TxScope setServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public ArrayList<Class<? extends Throwable>> getRollbackFor() {
        return this.rollbackFor;
    }

    public TxScope setRollbackFor(Class<? extends Throwable> rollbackThrowable) {
        if (this.rollbackFor == null) {
            this.rollbackFor = new ArrayList(2);
        }
        this.rollbackFor.add(rollbackThrowable);
        return this;
    }

    public TxScope setRollbackFor(Class<?>[] rollbackThrowables) {
        if (this.rollbackFor == null) {
            this.rollbackFor = new ArrayList(rollbackThrowables.length);
        }
        for (Class<?> rollbackThrowable : rollbackThrowables) {
            this.rollbackFor.add(rollbackThrowable);
        }
        return this;
    }

    public ArrayList<Class<? extends Throwable>> getNoRollbackFor() {
        return this.noRollbackFor;
    }

    public TxScope setNoRollbackFor(Class<? extends Throwable> noRollback) {
        if (this.noRollbackFor == null) {
            this.noRollbackFor = new ArrayList(2);
        }
        this.noRollbackFor.add(noRollback);
        return this;
    }

    public TxScope setNoRollbackFor(Class<?>[] noRollbacks) {
        if (this.noRollbackFor == null) {
            this.noRollbackFor = new ArrayList(noRollbacks.length);
        }
        for (Class<?> noRollback : noRollbacks) {
            this.noRollbackFor.add(noRollback);
        }
        return this;
    }

    public boolean isBatchMode() {
        return PersistBatch.ALL.equals((Object)this.batch);
    }

    public boolean isBatchOnCascade() {
        return PersistBatch.ALL.equals((Object)this.batchOnCascade);
    }
}

