/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import io.ebean.Database;
import io.ebean.DbContext;
import io.ebean.DbPrimary;
import io.ebean.EbeanVersion;
import io.ebean.config.ContainerConfig;
import io.ebean.config.DatabaseConfig;
import io.ebean.service.SpiContainer;
import io.ebean.service.SpiContainerFactory;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.PersistenceException;

public class DatabaseFactory {
    private static final ReentrantLock lock = new ReentrantLock(false);
    private static SpiContainer container;

    public static void initialiseContainer(ContainerConfig containerConfig) {
        lock.lock();
        try {
            DatabaseFactory.getContainer(containerConfig);
        }
        finally {
            lock.unlock();
        }
    }

    public static Database create(String name) {
        lock.lock();
        try {
            Database database = DatabaseFactory.getContainer(null).createServer(name);
            return database;
        }
        finally {
            lock.unlock();
        }
    }

    public static Database create(DatabaseConfig config) {
        lock.lock();
        try {
            if (config.getName() == null) {
                throw new PersistenceException("The name is null (it is required)");
            }
            Database server = DatabaseFactory.createInternal(config);
            if (config.isRegister()) {
                DbPrimary.setSkip(true);
                DbContext.getInstance().register(server, config.isDefaultServer());
            }
            Database database = server;
            return database;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database createWithContextClassLoader(DatabaseConfig config, ClassLoader classLoader) {
        lock.lock();
        try {
            ClassLoader currentContextLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            try {
                Database database = DatabaseFactory.create(config);
                Thread.currentThread().setContextClassLoader(currentContextLoader);
                return database;
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(currentContextLoader);
                throw throwable;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void shutdown() {
        lock.lock();
        try {
            container.shutdown();
        }
        finally {
            lock.unlock();
        }
    }

    private static Database createInternal(DatabaseConfig config) {
        return DatabaseFactory.getContainer(config.getContainerConfig()).createServer(config);
    }

    private static SpiContainer getContainer(ContainerConfig containerConfig) {
        if (container != null) {
            return container;
        }
        if (containerConfig == null) {
            Properties properties = DbPrimary.getProperties();
            containerConfig = new ContainerConfig();
            containerConfig.loadFromProperties(properties);
        }
        container = DatabaseFactory.createContainer(containerConfig);
        return container;
    }

    protected static SpiContainer createContainer(ContainerConfig containerConfig) {
        Iterator<SpiContainerFactory> factories = ServiceLoader.load(SpiContainerFactory.class).iterator();
        if (factories.hasNext()) {
            return factories.next().create(containerConfig);
        }
        throw new IllegalStateException("Service loader didn't find a SpiContainerFactory?");
    }

    static {
        EbeanVersion.getVersion();
    }
}

