package io.ebean.annotation;

/**
 * For IDENTITY specifies the generated ALWAYS or BY DEFAULT option.
 * <p>
 * Depending on the database there can be a performance gain in using
 * the GENERATED ALWAYS option.
 */
public enum IdentityGenerated {

  /**
   * Platform default option chosen.
   */
  AUTO,

  /**
   * Use GENERATED ALWAYS AS IDENTITY.
   */
  ALWAYS,

  /**
   * Use GENERATED BY DEFAULT AS IDENTITY.
   */
  BY_DEFAULT

}
