/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.views;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.views.ViewConfigurable;
import io.dropwizard.views.ViewMessageBodyWriter;
import io.dropwizard.views.ViewRenderer;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;

public class ViewBundle<T extends Configuration>
implements ConfiguredBundle<T>,
ViewConfigurable<T> {
    private final Iterable<ViewRenderer> viewRenderers;

    public ViewBundle() {
        this(ServiceLoader.load(ViewRenderer.class));
    }

    public ViewBundle(Iterable<ViewRenderer> viewRenderers) {
        this.viewRenderers = ImmutableSet.copyOf(viewRenderers);
    }

    @Override
    public Map<String, Map<String, String>> getViewConfiguration(T configuration) {
        return ImmutableMap.of();
    }

    public void run(T configuration, Environment environment) throws Exception {
        Map<String, Map<String, String>> options = this.getViewConfiguration(configuration);
        for (ViewRenderer viewRenderer : this.viewRenderers) {
            Map<String, String> viewOptions = options.get(viewRenderer.getConfigurationKey());
            viewRenderer.configure((Map)MoreObjects.firstNonNull(viewOptions, Collections.emptyMap()));
        }
        environment.jersey().register((Object)new ViewMessageBodyWriter(environment.metrics(), this.viewRenderers));
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }
}

