/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.views.mustache;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.MustacheResolver;
import com.github.mustachejava.resolver.FileSystemResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.dropwizard.views.View;
import io.dropwizard.views.ViewRenderException;
import io.dropwizard.views.ViewRenderer;
import io.dropwizard.views.mustache.PerClassMustacheResolver;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class MustacheViewRenderer
implements ViewRenderer {
    private static final Pattern FILE_PATTERN = Pattern.compile("\\.mustache");
    private final LoadingCache<Class<? extends View>, MustacheFactory> factories;
    private boolean useCache = true;
    private Optional<File> fileRoot = Optional.empty();

    public MustacheViewRenderer() {
        this.factories = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class<? extends View>, MustacheFactory>(){

            public MustacheFactory load(Class<? extends View> key) throws Exception {
                return MustacheViewRenderer.this.createNewMustacheFactory(key);
            }
        });
    }

    public boolean isRenderable(View view) {
        return FILE_PATTERN.matcher(view.getTemplateName()).find();
    }

    public void render(View view, Locale locale, OutputStream output) throws IOException {
        try {
            MustacheFactory mustacheFactory = this.useCache ? (MustacheFactory)this.factories.get(view.getClass()) : this.createNewMustacheFactory(view.getClass());
            Mustache template = mustacheFactory.compile(view.getTemplateName());
            Charset charset = view.getCharset().orElse(StandardCharsets.UTF_8);
            try (OutputStreamWriter writer = new OutputStreamWriter(output, charset);){
                template.execute((Writer)writer, (Object)view);
            }
        }
        catch (Throwable e) {
            throw new ViewRenderException("Mustache template error: " + view.getTemplateName(), e);
        }
    }

    public void configure(Map<String, String> options) {
        this.useCache = Optional.ofNullable(options.get("cache")).map(Boolean::parseBoolean).orElse(true);
        this.fileRoot = Optional.ofNullable(options.get("fileRoot")).map(File::new);
    }

    @VisibleForTesting
    boolean isUseCache() {
        return this.useCache;
    }

    public String getConfigurationKey() {
        return "mustache";
    }

    private MustacheFactory createNewMustacheFactory(Class<? extends View> key) {
        return new DefaultMustacheFactory((MustacheResolver)(this.fileRoot.isPresent() ? new FileSystemResolver(this.fileRoot.get()) : new PerClassMustacheResolver(key)));
    }
}

