/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.util;

import io.dropwizard.util.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;

public final class Resources {
    private Resources() {
    }

    public static URL getResource(String resourceName) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = contextClassLoader == null ? Resources.class.getClassLoader() : contextClassLoader;
        URL url = loader.getResource(resourceName);
        if (url == null) {
            throw new IllegalArgumentException("resource " + resourceName + " not found.");
        }
        return url;
    }

    @Deprecated
    public static byte[] toByteArray(URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            byte[] byArray = ByteStreams.toByteArray(inputStream);
            return byArray;
        }
    }

    @Deprecated
    public static String toString(URL url, Charset charset) throws IOException {
        try (InputStream inputStream = url.openStream();){
            String string = new String(ByteStreams.toByteArray(inputStream), charset);
            return string;
        }
    }

    @Deprecated
    public static void copy(URL from, OutputStream to) throws IOException {
        try (InputStream inputStream = from.openStream();){
            ByteStreams.copyInternal(inputStream, to);
        }
    }
}

