/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import com.codahale.metrics.MetricRegistry;
import io.dropwizard.Configuration;
import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.migrations.CloseableLiquibase;
import io.dropwizard.migrations.CloseableLiquibaseWithClassPathMigrationsFile;
import io.dropwizard.migrations.CloseableLiquibaseWithFileSystemMigrationsFile;
import io.dropwizard.setup.Bootstrap;
import java.sql.SQLException;
import javax.annotation.Nullable;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.exception.ValidationFailedException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public abstract class AbstractLiquibaseCommand<T extends Configuration>
extends ConfiguredCommand<T> {
    private final DatabaseConfiguration<T> strategy;
    private final Class<T> configurationClass;
    private final String migrationsFileName;

    protected AbstractLiquibaseCommand(String name, String description, DatabaseConfiguration<T> strategy, Class<T> configurationClass, String migrationsFileName) {
        super(name, description);
        this.strategy = strategy;
        this.configurationClass = configurationClass;
        this.migrationsFileName = migrationsFileName;
    }

    protected Class<T> getConfigurationClass() {
        return this.configurationClass;
    }

    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"--migrations"}).dest("migrations-file").help("the file containing the Liquibase migrations for the application");
        subparser.addArgument(new String[]{"--catalog"}).dest("catalog").help("Specify the database catalog (use database default if omitted)");
        subparser.addArgument(new String[]{"--schema"}).dest("schema").help("Specify the database schema (use database default if omitted)");
    }

    protected void run(@Nullable Bootstrap<T> bootstrap, Namespace namespace, T configuration) throws Exception {
        PooledDataSourceFactory dbConfig = this.strategy.getDataSourceFactory(configuration);
        dbConfig.asSingleConnectionPool();
        try (CloseableLiquibase liquibase = this.openLiquibase(dbConfig, namespace);){
            this.run(namespace, liquibase);
        }
        catch (ValidationFailedException e) {
            e.printDescriptiveError(System.err);
            throw e;
        }
    }

    CloseableLiquibase openLiquibase(PooledDataSourceFactory dataSourceFactory, Namespace namespace) throws SQLException, LiquibaseException {
        ManagedDataSource dataSource = dataSourceFactory.build(new MetricRegistry(), "liquibase");
        Database database = this.createDatabase(dataSource, namespace);
        String migrationsFile = namespace.getString("migrations-file");
        CloseableLiquibase liquibase = migrationsFile == null ? new CloseableLiquibaseWithClassPathMigrationsFile(dataSource, database, this.migrationsFileName) : new CloseableLiquibaseWithFileSystemMigrationsFile(dataSource, database, migrationsFile);
        return liquibase;
    }

    private Database createDatabase(ManagedDataSource dataSource, Namespace namespace) throws SQLException, LiquibaseException {
        JdbcConnection conn = new JdbcConnection(dataSource.getConnection());
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)conn);
        String catalogName = namespace.getString("catalog");
        String schemaName = namespace.getString("schema");
        if (database.supportsCatalogs() && catalogName != null) {
            database.setDefaultCatalogName(catalogName);
            database.setOutputDefaultCatalog(true);
        }
        if (database.supportsSchemas() && schemaName != null) {
            database.setDefaultSchemaName(schemaName);
            database.setOutputDefaultSchema(true);
        }
        return database;
    }

    protected abstract void run(Namespace var1, Liquibase var2) throws Exception;
}

