/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterables;
import io.dropwizard.jetty.BiDiGzipHandler;
import io.dropwizard.util.Size;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.server.Handler;

public class GzipHandlerFactory {
    private boolean enabled = true;
    @NotNull
    private Size minimumEntitySize = Size.bytes((long)256L);
    @NotNull
    private Size bufferSize = Size.kilobytes((long)8L);
    private Set<String> excludedUserAgentPatterns = new HashSet<String>();
    @Nullable
    private Set<String> compressedMimeTypes;
    @Nullable
    private Set<String> includedMethods;
    @Min(value=-1L)
    @Max(value=9L)
    private int deflateCompressionLevel = -1;
    private boolean gzipCompatibleInflation = true;
    private boolean syncFlush = false;

    @JsonProperty
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonProperty
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonProperty
    public Size getMinimumEntitySize() {
        return this.minimumEntitySize;
    }

    @JsonProperty
    public void setMinimumEntitySize(Size size) {
        this.minimumEntitySize = Objects.requireNonNull(size);
    }

    @JsonProperty
    public Size getBufferSize() {
        return this.bufferSize;
    }

    @JsonProperty
    public void setBufferSize(Size size) {
        this.bufferSize = Objects.requireNonNull(size);
    }

    @JsonProperty
    @Nullable
    public Set<String> getCompressedMimeTypes() {
        return this.compressedMimeTypes;
    }

    @JsonProperty
    public void setCompressedMimeTypes(Set<String> mimeTypes) {
        this.compressedMimeTypes = mimeTypes;
    }

    @JsonProperty
    public int getDeflateCompressionLevel() {
        return this.deflateCompressionLevel;
    }

    @JsonProperty
    public void setDeflateCompressionLevel(int level) {
        this.deflateCompressionLevel = level;
    }

    @JsonProperty
    public boolean isGzipCompatibleInflation() {
        return this.gzipCompatibleInflation;
    }

    @JsonProperty
    public void setGzipCompatibleInflation(boolean gzipCompatibleInflation) {
        this.gzipCompatibleInflation = gzipCompatibleInflation;
    }

    public Set<String> getExcludedUserAgentPatterns() {
        return this.excludedUserAgentPatterns;
    }

    public void setExcludedUserAgentPatterns(Set<String> excludedUserAgentPatterns) {
        this.excludedUserAgentPatterns = excludedUserAgentPatterns;
    }

    @JsonProperty
    @Nullable
    public Set<String> getIncludedMethods() {
        return this.includedMethods;
    }

    @JsonProperty
    public void setIncludedMethods(Set<String> methods) {
        this.includedMethods = methods;
    }

    @JsonProperty
    public boolean isSyncFlush() {
        return this.syncFlush;
    }

    @JsonProperty
    public void setSyncFlush(boolean syncFlush) {
        this.syncFlush = syncFlush;
    }

    public BiDiGzipHandler build(@Nullable Handler handler) {
        BiDiGzipHandler gzipHandler = new BiDiGzipHandler();
        gzipHandler.setHandler(handler);
        gzipHandler.setMinGzipSize((int)this.minimumEntitySize.toBytes());
        gzipHandler.setInputBufferSize((int)this.bufferSize.toBytes());
        gzipHandler.setCompressionLevel(this.deflateCompressionLevel);
        gzipHandler.setSyncFlush(this.syncFlush);
        if (this.compressedMimeTypes != null) {
            gzipHandler.setIncludedMimeTypes((String[])Iterables.toArray(this.compressedMimeTypes, String.class));
        }
        if (this.includedMethods != null) {
            gzipHandler.setIncludedMethods((String[])Iterables.toArray(this.includedMethods, String.class));
        }
        gzipHandler.setExcludedAgentPatterns((String[])Iterables.toArray(this.excludedUserAgentPatterns, String.class));
        gzipHandler.setInflateNoWrap(this.gzipCompatibleInflation);
        return gzipHandler;
    }
}

