/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.validation;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.dropwizard.jersey.validation.JerseyParameterNameProvider;
import io.dropwizard.util.Lists;
import io.dropwizard.util.Strings;
import io.dropwizard.validation.ValidationMethod;
import io.dropwizard.validation.selfvalidating.SelfValidating;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.Parameter;

public class ConstraintMessage {
    private static final Cache<Pair<Path, ? extends ConstraintDescriptor<?>>, String> PREFIX_CACHE = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();

    private ConstraintMessage() {
    }

    public static String getMessage(ConstraintViolation<?> v, Invocable invocable) {
        Pair of = Pair.of((Object)v.getPropertyPath(), (Object)v.getConstraintDescriptor());
        String cachePrefix = (String)PREFIX_CACHE.getIfPresent((Object)of);
        if (cachePrefix == null) {
            String prefix = ConstraintMessage.calculatePrefix(v, invocable);
            PREFIX_CACHE.put((Object)of, (Object)prefix);
            return prefix + v.getMessage();
        }
        return cachePrefix + v.getMessage();
    }

    private static String calculatePrefix(ConstraintViolation<?> v, Invocable invocable) {
        Optional<String> returnValueName = ConstraintMessage.getMethodReturnValueName(v);
        if (returnValueName.isPresent()) {
            String name = ConstraintMessage.isValidationMethod(v) ? StringUtils.substringBeforeLast((String)returnValueName.get(), (String)".") : returnValueName.get();
            return name + " ";
        }
        if (ConstraintMessage.isValidationMethod(v) || ConstraintMessage.isSelfValidating(v)) {
            return "";
        }
        Optional<String> entity = ConstraintMessage.isRequestEntity(v, invocable);
        if (entity.isPresent()) {
            String prefix = Strings.isNullOrEmpty((String)entity.get()) ? "The request body" : entity.get();
            return prefix + " ";
        }
        Optional<String> memberName = ConstraintMessage.getMemberName(v, invocable);
        return memberName.map(s -> s + " ").orElseGet(() -> v.getPropertyPath() + " ");
    }

    public static Optional<String> isRequestEntity(ConstraintViolation<?> violation, Invocable invocable) {
        Parameter param;
        List propertyPath = Lists.of((Iterable)violation.getPropertyPath());
        Path.Node parent = propertyPath.stream().skip(1L).findFirst().orElse(null);
        if (parent == null) {
            return Optional.empty();
        }
        List parameters = invocable.getParameters();
        if (parent.getKind() == ElementKind.PARAMETER && (param = (Parameter)parameters.get(((Path.ParameterNode)parent.as(Path.ParameterNode.class)).getParameterIndex())).getSource().equals((Object)Parameter.Source.UNKNOWN)) {
            String path = propertyPath.stream().skip(2L).map(Path.Node::toString).collect(Collectors.joining("."));
            return Optional.of(path);
        }
        return Optional.empty();
    }

    private static Optional<String> getMemberName(ConstraintViolation<?> violation, Invocable invocable) {
        List propertyPath = Lists.of((Iterable)violation.getPropertyPath());
        int size = propertyPath.size();
        if (size < 2) {
            return Optional.empty();
        }
        Path.Node parent = (Path.Node)propertyPath.get(size - 2);
        Path.Node member = (Path.Node)propertyPath.get(size - 1);
        switch (parent.getKind()) {
            case PARAMETER: {
                List parameters = invocable.getParameters();
                Parameter param = (Parameter)parameters.get(((Path.ParameterNode)parent.as(Path.ParameterNode.class)).getParameterIndex());
                if (!param.getSource().equals((Object)Parameter.Source.BEAN_PARAM)) break;
                Field field = FieldUtils.getField((Class)param.getRawType(), (String)member.getName(), (boolean)true);
                return JerseyParameterNameProvider.getParameterNameFromAnnotations(field.getDeclaredAnnotations());
            }
            case METHOD: {
                return Optional.of(member.getName());
            }
        }
        return Optional.empty();
    }

    private static Optional<String> getMethodReturnValueName(ConstraintViolation<?> violation) {
        int returnValueNames = -1;
        StringBuilder result = new StringBuilder("server response");
        for (Path.Node node : violation.getPropertyPath()) {
            if (node.getKind().equals((Object)ElementKind.RETURN_VALUE)) {
                returnValueNames = 0;
                continue;
            }
            if (returnValueNames < 0) continue;
            result.append(returnValueNames++ == 0 ? " " : ".").append(node);
        }
        return returnValueNames >= 0 ? Optional.of(result.toString()) : Optional.empty();
    }

    private static boolean isValidationMethod(ConstraintViolation<?> v) {
        return v.getConstraintDescriptor().getAnnotation() instanceof ValidationMethod;
    }

    private static boolean isSelfValidating(ConstraintViolation<?> v) {
        return v.getConstraintDescriptor().getAnnotation() instanceof SelfValidating;
    }

    public static <T extends ConstraintViolation<?>> int determineStatus(Set<T> violations, Invocable invocable) {
        if (violations.size() > 0) {
            ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
            for (Path.Node node : violation.getPropertyPath()) {
                switch (node.getKind()) {
                    case RETURN_VALUE: {
                        return 500;
                    }
                    case PARAMETER: {
                        int index = ((Path.ParameterNode)node.as(Path.ParameterNode.class)).getParameterIndex();
                        Parameter parameter = (Parameter)invocable.getParameters().get(index);
                        return parameter.getSource().equals((Object)Parameter.Source.UNKNOWN) ? 422 : 400;
                    }
                }
            }
        }
        return 422;
    }
}

