/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health;

import com.codahale.metrics.Counter;
import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.health.HealthCheckType;
import io.dropwizard.health.HealthStateView;
import io.dropwizard.health.Schedule;
import io.dropwizard.health.State;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScheduledHealthCheck
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledHealthCheck.class);
    private final String name;
    private final HealthCheckType type;
    private final boolean critical;
    private final HealthCheck healthCheck;
    private final Schedule schedule;
    private final State state;
    private final Counter healthyCheckCounter;
    private final Counter unhealthyCheckCounter;
    private boolean previouslyRecovered = false;

    ScheduledHealthCheck(String name, HealthCheckType type, boolean critical, HealthCheck healthCheck, Schedule schedule, State state, Counter healthyCheckCounter, Counter unhealthyCheckCounter) {
        this.name = Objects.requireNonNull(name);
        this.type = type;
        this.critical = critical;
        this.healthCheck = Objects.requireNonNull(healthCheck);
        this.schedule = Objects.requireNonNull(schedule);
        this.state = Objects.requireNonNull(state);
        this.healthyCheckCounter = Objects.requireNonNull(healthyCheckCounter);
        this.unhealthyCheckCounter = Objects.requireNonNull(unhealthyCheckCounter);
    }

    public String getName() {
        return this.name;
    }

    public HealthCheckType getType() {
        return this.type;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public boolean isHealthy() {
        return this.state.getHealthy().get();
    }

    public boolean isPreviouslyRecovered() {
        return this.previouslyRecovered;
    }

    @Override
    public void run() {
        HealthCheck.Result result;
        LOGGER.trace("executing health check: name={}", (Object)this.name);
        boolean previousState = this.state.getHealthy().get();
        try {
            result = this.healthCheck.execute();
        }
        catch (Exception e) {
            LOGGER.warn("Check for name={} failed exceptionally", (Object)this.name, (Object)e);
            result = HealthCheck.Result.unhealthy((Throwable)e);
        }
        if (result.isHealthy()) {
            LOGGER.trace("health check result: name={} result=success", (Object)this.name);
            this.state.success();
            this.healthyCheckCounter.inc();
            if (!this.previouslyRecovered && !previousState) {
                this.previouslyRecovered = true;
            }
        } else {
            LOGGER.trace("health check result: name={} result=failure result={}", (Object)this.name, (Object)result);
            this.state.failure();
            this.unhealthyCheckCounter.inc();
        }
    }

    public HealthStateView view() {
        return new HealthStateView(this.name, this.isHealthy(), this.type, this.isCritical());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledHealthCheck)) {
            return false;
        }
        ScheduledHealthCheck that = (ScheduledHealthCheck)o;
        return this.critical == that.critical && Objects.equals(this.name, that.name) && Objects.equals(this.healthCheck, that.healthCheck) && Objects.equals(this.schedule, that.schedule) && Objects.equals(this.state, that.state) && Objects.equals(this.healthyCheckCounter, that.healthyCheckCounter) && Objects.equals(this.unhealthyCheckCounter, that.unhealthyCheckCounter);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.critical, this.healthCheck, this.schedule, this.state, this.healthyCheckCounter, this.unhealthyCheckCounter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ScheduledHealthCheck{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", critical=").append(this.critical);
        sb.append(", healthCheck=").append(this.healthCheck);
        sb.append(", schedule=").append(this.schedule);
        sb.append(", state=").append(this.state);
        sb.append(", healthyCheckCounter=").append(this.getCounterString(this.healthyCheckCounter));
        sb.append(", unhealthyCheckCounter=").append(this.getCounterString(this.unhealthyCheckCounter));
        sb.append(", previouslyRecovered=").append(this.previouslyRecovered);
        sb.append('}');
        return sb.toString();
    }

    private String getCounterString(Counter counter) {
        return Counter.class.equals(counter.getClass()) ? String.valueOf(counter.getCount()) : counter.toString();
    }
}

