/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.assets;

import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.servlets.assets.AssetServlet;
import io.dropwizard.setup.Environment;
import java.nio.charset.StandardCharsets;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetsBundle
implements ConfiguredBundle<Configuration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssetsBundle.class);
    private static final String DEFAULT_ASSETS_NAME = "assets";
    private static final String DEFAULT_INDEX_FILE = "index.htm";
    private static final String DEFAULT_PATH = "/assets";
    private static final String DEFAULT_MEDIA_TYPE = "text/html";
    private final String resourcePath;
    private final String uriPath;
    private final String indexFile;
    private final String assetsName;
    private final String defaultMediaType;

    public AssetsBundle() {
        this(DEFAULT_PATH, DEFAULT_PATH, DEFAULT_INDEX_FILE, DEFAULT_ASSETS_NAME, DEFAULT_MEDIA_TYPE);
    }

    public AssetsBundle(String path) {
        this(path, path, DEFAULT_INDEX_FILE, DEFAULT_ASSETS_NAME, DEFAULT_MEDIA_TYPE);
    }

    public AssetsBundle(String resourcePath, String uriPath) {
        this(resourcePath, uriPath, DEFAULT_INDEX_FILE, DEFAULT_ASSETS_NAME, DEFAULT_MEDIA_TYPE);
    }

    public AssetsBundle(String resourcePath, String uriPath, String indexFile) {
        this(resourcePath, uriPath, indexFile, DEFAULT_ASSETS_NAME, DEFAULT_MEDIA_TYPE);
    }

    public AssetsBundle(String resourcePath, String uriPath, String indexFile, String assetsName) {
        this(resourcePath, uriPath, indexFile, assetsName, DEFAULT_MEDIA_TYPE);
    }

    public AssetsBundle(String resourcePath, String uriPath, String indexFile, String assetsName, String defaultMediaType) {
        if (!resourcePath.startsWith("/")) {
            throw new IllegalArgumentException(resourcePath + " is not an absolute path");
        }
        if ("/".equals(resourcePath)) {
            throw new IllegalArgumentException(resourcePath + " is the classpath root");
        }
        this.resourcePath = resourcePath.endsWith("/") ? resourcePath : resourcePath + '/';
        this.uriPath = uriPath.endsWith("/") ? uriPath : uriPath + '/';
        this.indexFile = indexFile;
        this.assetsName = assetsName;
        this.defaultMediaType = defaultMediaType;
    }

    public void run(Configuration configuration, Environment environment) {
        String pathPattern = this.uriPath + '*';
        LOGGER.info("Registering AssetBundle with name: {} for path {}", (Object)this.assetsName, (Object)pathPattern);
        environment.servlets().addServlet(this.assetsName, (Servlet)this.createServlet()).addMapping(new String[]{pathPattern});
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getUriPath() {
        return this.uriPath;
    }

    public String getIndexFile() {
        return this.indexFile;
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    protected AssetServlet createServlet() {
        return new AssetServlet(this.resourcePath, this.uriPath, this.indexFile, this.defaultMediaType, StandardCharsets.UTF_8);
    }
}

