/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.storage;

import io.delta.standalone.data.CloseableIterator;
import io.delta.standalone.internal.storage.LineCloseableIterator;
import io.delta.standalone.storage.LogStore;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m4Q!\u0003\u0006\u0002\u0002UA\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0005\b\u0005\tS\u0001\u0011\t\u0011)A\u0005;!)!\u0006\u0001C\u0001W!)q\u0006\u0001C!a!)a\n\u0001C!\u001f\")Q\f\u0001C!=\")\u0011\r\u0001C\tE\")\u0001\u0010\u0001C\ts\nA\u0002*\u00193p_B4\u0015\u000e\\3TsN$X-\u001c'pON#xN]3\u000b\u0005-a\u0011aB:u_J\fw-\u001a\u0006\u0003\u001b9\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001fA\t!b\u001d;b]\u0012\fGn\u001c8f\u0015\t\t\"#A\u0003eK2$\u0018MC\u0001\u0014\u0003\tIwn\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u001a\u001b\u0005A\"BA\u0006\u000f\u0013\tQ\u0002D\u0001\u0005M_\u001e\u001cFo\u001c:f\u00039Ig.\u001b;IC\u0012|w\u000e]\"p]\u001a,\u0012!\b\t\u0003=\u001dj\u0011a\b\u0006\u0003A\u0005\nAaY8oM*\u0011!eI\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0005\u0003Q}\u0011QbQ8oM&<WO]1uS>t\u0017aD5oSRD\u0015\rZ8pa\u000e{gN\u001a\u0011\u0002\rqJg.\u001b;?)\tac\u0006\u0005\u0002.\u00015\t!\u0002C\u0003\u001c\u0007\u0001\u0007Q$\u0001\u0003sK\u0006$GcA\u0019E\u0019B\u0019!'N\u001c\u000e\u0003MR!\u0001\u000e\b\u0002\t\u0011\fG/Y\u0005\u0003mM\u0012\u0011c\u00117pg\u0016\f'\r\\3Ji\u0016\u0014\u0018\r^8s!\tA\u0014I\u0004\u0002:\u007fA\u0011!(P\u0007\u0002w)\u0011A\bF\u0001\u0007yI|w\u000e\u001e \u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0002\rA\u0013X\rZ3g\u0013\t\u00115I\u0001\u0004TiJLgn\u001a\u0006\u0003\u0001vBQ!\u0012\u0003A\u0002\u0019\u000bA\u0001]1uQB\u0011qIS\u0007\u0002\u0011*\u0011\u0011*I\u0001\u0003MNL!a\u0013%\u0003\tA\u000bG\u000f\u001b\u0005\u0006\u001b\u0012\u0001\r!H\u0001\u000bQ\u0006$wn\u001c9D_:4\u0017\u0001\u00037jgR4%o\\7\u0015\u0007A[F\fE\u0002R-bk\u0011A\u0015\u0006\u0003'R\u000bA!\u001e;jY*\tQ+\u0001\u0003kCZ\f\u0017BA,S\u0005!IE/\u001a:bi>\u0014\bCA$Z\u0013\tQ\u0006J\u0001\u0006GS2,7\u000b^1ukNDQ!R\u0003A\u0002\u0019CQ!T\u0003A\u0002u\tAD]3t_24X\rU1uQ>s\u0007\u000b[=tS\u000e\fGn\u0015;pe\u0006<W\rF\u0002G?\u0002DQ!\u0012\u0004A\u0002\u0019CQ!\u0014\u0004A\u0002u\tqb\u001e:ji\u0016<\u0016\u000e\u001e5SK:\fW.\u001a\u000b\u0006G\u001eD'o\u001e\t\u0003I\u0016l\u0011!P\u0005\u0003Mv\u0012A!\u00168ji\")Qi\u0002a\u0001\r\")\u0011n\u0002a\u0001U\u00069\u0011m\u0019;j_:\u001c\bcA6qo9\u0011AN\u001c\b\u0003u5L\u0011AP\u0005\u0003_v\nq\u0001]1dW\u0006<W-\u0003\u0002Xc*\u0011q.\u0010\u0005\u0006g\u001e\u0001\r\u0001^\u0001\n_Z,'o\u001e:ji\u0016\u0004\"\u0001Z;\n\u0005Yl$a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001b\u001e\u0001\r!H\u0001\u000fGJ,\u0017\r^3UK6\u0004\b+\u0019;i)\t1%\u0010C\u0003F\u0011\u0001\u0007a\t")
public abstract class HadoopFileSystemLogStore
extends LogStore {
    private final Configuration initHadoopConf;

    @Override
    public Configuration initHadoopConf() {
        return this.initHadoopConf;
    }

    @Override
    public CloseableIterator<String> read(Path path, Configuration hadoopConf) {
        FileSystem fs = path.getFileSystem(hadoopConf);
        FSDataInputStream stream = fs.open(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
        return new LineCloseableIterator(reader);
    }

    @Override
    public java.util.Iterator<FileStatus> listFrom(Path path, Configuration hadoopConf) {
        FileSystem fs = path.getFileSystem(hadoopConf);
        if (!fs.exists(path.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path.getParent()).toString());
        }
        FileStatus[] files = fs.listStatus(path.getParent());
        return (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopFileSystemLogStore.$anonfun$listFrom$1(path, x$1))))).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().getName(), (Ordering)Ordering.String$.MODULE$))).iterator()).asJava();
    }

    @Override
    public Path resolvePathOnPhysicalStorage(Path path, Configuration hadoopConf) {
        return path.getFileSystem(hadoopConf).makeQualified(path);
    }

    public void writeWithRename(Path path, Iterator<String> actions, boolean overwrite, Configuration hadoopConf) {
        block15: {
            FileSystem fs = path.getFileSystem(hadoopConf);
            if (!fs.exists(path.getParent())) {
                throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path.getParent()).toString());
            }
            if (overwrite) {
                try (FSDataOutputStream stream = fs.create(path, true);){
                    actions.map((Function1 & Serializable & scala.Serializable)x$3 -> new StringBuilder(1).append((String)x$3).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        stream.write(x$1);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            if (fs.exists(path)) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
            Path tempPath = this.createTempPath(path);
            boolean streamClosed = false;
            boolean renameDone = false;
            FSDataOutputStream stream = fs.create(tempPath);
            try {
                actions.map((Function1 & Serializable & scala.Serializable)x$5 -> new StringBuilder(1).append((String)x$5).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    stream.write(x$1);
                    return BoxedUnit.UNIT;
                });
                stream.close();
                streamClosed = true;
                try {
                    if (fs.rename(tempPath, path)) {
                        renameDone = true;
                        break block15;
                    }
                    if (fs.exists(path)) {
                        throw new java.nio.file.FileAlreadyExistsException(path.toString());
                    }
                    throw new IllegalStateException(new StringBuilder(18).append("Cannot rename ").append(tempPath).append(" to ").append(path).toString());
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    throw new java.nio.file.FileAlreadyExistsException(path.toString());
                }
            }
            finally {
                if (!streamClosed) {
                    stream.close();
                }
                if (!renameDone) {
                    fs.delete(tempPath, false);
                }
            }
        }
    }

    public Path createTempPath(Path path) {
        return new Path(path.getParent(), new StringBuilder(6).append(".").append(path.getName()).append(".").append(UUID.randomUUID()).append(".tmp").toString());
    }

    public static final /* synthetic */ boolean $anonfun$listFrom$1(Path path$1, FileStatus x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.getPath().getName())).$greater$eq((Object)path$1.getName());
    }

    public HadoopFileSystemLogStore(Configuration initHadoopConf) {
        this.initHadoopConf = initHadoopConf;
        super(initHadoopConf);
    }
}

