package io.dekorate.kind.config;

import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import io.dekorate.kubernetes.config.Job;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.config.CronJob;
import java.lang.Object;
import java.util.Map;
import io.dekorate.kubernetes.config.GitRepoVolume;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.Label.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.Annotation.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.Env.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.PersistentVolumeClaimVolume.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.SecretVolume.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.ConfigMapVolume.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.EmptyDirVolume.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.GitRepoVolume.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.AzureDiskVolume.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.AzureFileVolume.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.Mount.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.RollingUpdate.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.HostAlias.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.Container.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.Job.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.CronJob.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class KindConfig extends BaseConfig{
  public KindConfig() {
  }
  
  public KindConfig(Project project,Map<ConfigKey,Object> attributes,String partOf,String name,String version,String deploymentKind,Label[] labels,Annotation[] annotations,Env[] envVars,String workingDir,String[] command,String[] arguments,String serviceAccount,Port[] ports,ServiceType serviceType,PersistentVolumeClaimVolume[] pvcVolumes,SecretVolume[] secretVolumes,ConfigMapVolume[] configMapVolumes,EmptyDirVolume[] emptyDirVolumes,GitRepoVolume[] gitRepoVolumes,AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes,AzureDiskVolume[] azureDiskVolumes,AzureFileVolume[] azureFileVolumes,Mount[] mounts,ImagePullPolicy imagePullPolicy,String[] imagePullSecrets,DeploymentStrategy deploymentStrategy,RollingUpdate rollingUpdate,HostAlias[] hostAliases,Probe livenessProbe,Probe readinessProbe,Probe startupProbe,ResourceRequirements requestResources,ResourceRequirements limitResources,Container[] sidecars,Boolean autoDeployEnabled,Job[] jobs,CronJob[] cronJobs,Boolean enabled) {
    super(project, attributes, partOf, name, version, deploymentKind, labels, annotations, envVars, workingDir, command, arguments, serviceAccount, ports, serviceType, pvcVolumes, secretVolumes, configMapVolumes, emptyDirVolumes, gitRepoVolumes, awsElasticBlockStoreVolumes, azureDiskVolumes, azureFileVolumes, mounts, imagePullPolicy, imagePullSecrets, deploymentStrategy, rollingUpdate, hostAliases, livenessProbe, readinessProbe, startupProbe, requestResources, limitResources, sidecars, autoDeployEnabled, jobs, cronJobs);
    this.enabled = enabled;
  }
  private Boolean enabled;
  
  public Boolean getEnabled() {
    return this.enabled;
  }
  
  public boolean isEnabled() {
    return this.enabled != null &&  this.enabled;
  }
  
  public static KindConfigBuilder newKindConfigBuilder() {
    return new KindConfigBuilder();
  }
  
  public static KindConfigBuilder newKindConfigBuilderFromDefaults() {
    return new KindConfigBuilder().withEnabled(true).withImagePullPolicy(io.dekorate.kubernetes.annotation.ImagePullPolicy.IfNotPresent).withServiceType(io.dekorate.kubernetes.annotation.ServiceType.NodePort);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KindConfig that = (KindConfig) o;
    if (!java.util.Objects.equals(enabled, that.enabled)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(enabled,  super.hashCode());
  }
  

}