/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kind.manifest;

import io.dekorate.ConfigurationRegistry;
import io.dekorate.ResourceRegistry;
import io.dekorate.kind.config.KindConfig;
import io.dekorate.kind.decorator.ApplyServiceTypeToKindServiceDecorator;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.decorator.ApplyNodePortToServiceDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.manifest.KubernetesManifestGenerator;
import java.util.Optional;

public class KindManifestGenerator
extends KubernetesManifestGenerator {
    private static final String KIND = "kind";
    private static final String FALLBACK_TARGET_PORT = "http";

    public KindManifestGenerator() {
        this(new ResourceRegistry(), new ConfigurationRegistry());
    }

    public KindManifestGenerator(ResourceRegistry resourceRegistry, ConfigurationRegistry configurationRegistry) {
        super(resourceRegistry, configurationRegistry);
    }

    public int order() {
        return 400;
    }

    public String getKey() {
        return KIND;
    }

    public void generate(KubernetesConfig kubernetesConfig) {
        this.initializeRegistry((BaseConfig)kubernetesConfig);
        Optional kindConfig = this.configurationRegistry.get(KindConfig.class);
        this.addDecorators(KIND, (KubernetesConfig)((KubernetesConfigBuilder)new KubernetesConfigBuilder(kubernetesConfig).withImagePullPolicy(kindConfig.map(c -> c.getImagePullPolicy()).orElse(kubernetesConfig.getImagePullPolicy()))).build());
        kindConfig.ifPresent(c -> {
            this.resourceRegistry.decorate(KIND, (Decorator)new ApplyServiceTypeToKindServiceDecorator(kubernetesConfig.getName(), (KindConfig)((Object)c)));
            if (c.getPorts().length > 0) {
                this.resourceRegistry.decorate(KIND, (Decorator)new ApplyNodePortToServiceDecorator((BaseConfig)kubernetesConfig, c.getPorts(), FALLBACK_TARGET_PORT));
            } else {
                this.resourceRegistry.decorate(KIND, (Decorator)new ApplyNodePortToServiceDecorator((BaseConfig)kubernetesConfig, kubernetesConfig.getPorts(), FALLBACK_TARGET_PORT));
            }
        });
    }
}

