/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver.metrics;

import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.connector.sqlserver.metrics.AbstractSqlServerTaskMetrics;
import io.debezium.connector.sqlserver.metrics.SqlServerSnapshotPartitionMetrics;
import io.debezium.pipeline.metrics.SnapshotChangeEventSourceMetrics;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.util.Collection;

class SqlServerSnapshotTaskMetrics
extends AbstractSqlServerTaskMetrics<SqlServerSnapshotPartitionMetrics>
implements SnapshotChangeEventSourceMetrics<SqlServerPartition> {
    SqlServerSnapshotTaskMetrics(CdcSourceTaskContext taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider, Collection<SqlServerPartition> partitions) {
        super(taskContext, "snapshot", changeEventQueueMetrics, partitions, partition -> new SqlServerSnapshotPartitionMetrics(taskContext, Collect.linkMapOf((Object)"server", (Object)taskContext.getConnectorName(), (Object)"task", (Object)taskContext.getTaskId(), (Object)"context", (Object)"snapshot", (Object)"database", (Object)partition.getDatabaseName()), metadataProvider));
    }

    public void snapshotStarted(SqlServerPartition partition) {
        this.onPartitionEvent(partition, SqlServerSnapshotPartitionMetrics::snapshotStarted);
    }

    public void snapshotPaused(SqlServerPartition partition) {
        this.onPartitionEvent(partition, SqlServerSnapshotPartitionMetrics::snapshotPaused);
    }

    public void snapshotResumed(SqlServerPartition partition) {
        this.onPartitionEvent(partition, SqlServerSnapshotPartitionMetrics::snapshotResumed);
    }

    public void monitoredDataCollectionsDetermined(SqlServerPartition partition, Iterable<? extends DataCollectionId> dataCollectionIds) {
        this.onPartitionEvent(partition, bean -> bean.monitoredDataCollectionsDetermined(dataCollectionIds));
    }

    public void snapshotCompleted(SqlServerPartition partition) {
        this.onPartitionEvent(partition, SqlServerSnapshotPartitionMetrics::snapshotCompleted);
    }

    public void snapshotAborted(SqlServerPartition partition) {
        this.onPartitionEvent(partition, SqlServerSnapshotPartitionMetrics::snapshotAborted);
    }

    public void dataCollectionSnapshotCompleted(SqlServerPartition partition, DataCollectionId dataCollectionId, long numRows) {
        this.onPartitionEvent(partition, bean -> bean.dataCollectionSnapshotCompleted(dataCollectionId, numRows));
    }

    public void rowsScanned(SqlServerPartition partition, TableId tableId, long numRows) {
        this.onPartitionEvent(partition, bean -> bean.rowsScanned(tableId, numRows));
    }

    public void currentChunk(SqlServerPartition partition, String chunkId, Object[] chunkFrom, Object[] chunkTo) {
        this.onPartitionEvent(partition, bean -> bean.currentChunk(chunkId, chunkFrom, chunkTo));
    }

    public void currentChunk(SqlServerPartition partition, String chunkId, Object[] chunkFrom, Object[] chunkTo, Object[] tableTo) {
        this.onPartitionEvent(partition, bean -> bean.currentChunk(chunkId, chunkFrom, chunkTo, tableTo));
    }
}

