/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.GtidSet;
import io.debezium.document.Document;
import io.debezium.relational.history.HistoryRecordComparator;
import java.util.function.Predicate;

final class MySqlHistoryRecordComparator
extends HistoryRecordComparator {
    private final Predicate<String> gtidSourceFilter;

    MySqlHistoryRecordComparator(Predicate<String> gtidSourceFilter) {
        this.gtidSourceFilter = gtidSourceFilter;
    }

    protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
        int desiredRow;
        int desiredEventCount;
        int desiredPosition;
        BinlogFilename desiredFilename;
        int desiredServerId;
        String recordedGtidSetStr = recorded.getString((CharSequence)"gtids");
        String desiredGtidSetStr = desired.getString((CharSequence)"gtids");
        if (desiredGtidSetStr != null) {
            if (recordedGtidSetStr != null) {
                GtidSet recordedGtidSet = new GtidSet(recordedGtidSetStr);
                GtidSet desiredGtidSet = new GtidSet(desiredGtidSetStr);
                if (this.gtidSourceFilter != null) {
                    recordedGtidSet = recordedGtidSet.retainAll(this.gtidSourceFilter);
                    desiredGtidSet = desiredGtidSet.retainAll(this.gtidSourceFilter);
                }
                if (recordedGtidSet.equals(desiredGtidSet)) {
                    int desiredEventCount2;
                    if (!recorded.has((CharSequence)"snapshot") && desired.has((CharSequence)"snapshot")) {
                        return false;
                    }
                    int recordedEventCount = recorded.getInteger((CharSequence)"event", 0);
                    int diff = recordedEventCount - (desiredEventCount2 = desired.getInteger((CharSequence)"event", 0));
                    return diff <= 0;
                }
                return recordedGtidSet.isContainedWithin(desiredGtidSet);
            }
            return true;
        }
        if (recordedGtidSetStr != null) {
            return false;
        }
        int recordedServerId = recorded.getInteger((CharSequence)"server_id", 0);
        if (recordedServerId != (desiredServerId = recorded.getInteger((CharSequence)"server_id", 0))) {
            long desiredTimestamp;
            long recordedTimestamp = recorded.getLong((CharSequence)"ts_ms", 0L);
            return recordedTimestamp <= (desiredTimestamp = recorded.getLong((CharSequence)"ts_ms", 0L));
        }
        BinlogFilename recordedFilename = BinlogFilename.of(recorded.getString((CharSequence)"file"));
        int diff = recordedFilename.compareTo(desiredFilename = BinlogFilename.of(desired.getString((CharSequence)"file")));
        if (diff > 0) {
            return false;
        }
        if (diff < 0) {
            return true;
        }
        int recordedPosition = recorded.getInteger((CharSequence)"pos", -1);
        diff = recordedPosition - (desiredPosition = desired.getInteger((CharSequence)"pos", -1));
        if (diff > 0) {
            return false;
        }
        if (diff < 0) {
            return true;
        }
        int recordedEventCount = recorded.getInteger((CharSequence)"event", 0);
        diff = recordedEventCount - (desiredEventCount = desired.getInteger((CharSequence)"event", 0));
        if (diff > 0) {
            return false;
        }
        if (diff < 0) {
            return true;
        }
        int recordedRow = recorded.getInteger((CharSequence)"row", -1);
        diff = recordedRow - (desiredRow = desired.getInteger((CharSequence)"row", -1));
        return diff <= 0;
    }

    private static class BinlogFilename
    implements Comparable<BinlogFilename> {
        private final String baseName;
        private final long extension;

        private BinlogFilename(String baseName, long extension) {
            this.baseName = baseName;
            this.extension = extension;
        }

        public static BinlogFilename of(String filename) {
            long extension;
            int index = filename.lastIndexOf(".");
            if (index == -1) {
                throw new IllegalArgumentException("Filename does not have an extension: " + filename);
            }
            String baseFilename = filename.substring(0, index);
            String stringExtension = filename.substring(index + 1);
            try {
                extension = Long.parseLong(stringExtension);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Can't parse binlog filename extension: " + filename, e);
            }
            return new BinlogFilename(baseFilename, extension);
        }

        public String toString() {
            return "BinlogFilename [baseName=" + this.baseName + ", extension=" + this.extension + "]";
        }

        @Override
        public int compareTo(BinlogFilename other) {
            if (!this.baseName.equals(other.baseName)) {
                throw new IllegalArgumentException("Can't compare binlog filenames with different base names");
            }
            return Long.compare(this.extension, other.extension);
        }
    }
}

