/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.runtime.CucumberExecutionContext;
import io.cucumber.junit.FileNameCompatibleNames;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.JUnitReporter;
import io.cucumber.plugin.event.Step;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

final class PickleRunners {
    PickleRunners() {
    }

    static PickleRunner withStepDescriptions(CucumberExecutionContext context, Pickle pickle, Integer uniqueSuffix, JUnitOptions options) {
        try {
            return new WithStepDescriptions(context, pickle, uniqueSuffix, options);
        }
        catch (InitializationError e) {
            throw new CucumberException("Failed to create scenario runner", (Throwable)e);
        }
    }

    static PickleRunner withNoStepDescriptions(String featureName, CucumberExecutionContext context, Pickle pickle, Integer uniqueSuffix, JUnitOptions jUnitOptions) {
        return new NoStepDescriptions(featureName, context, pickle, uniqueSuffix, jUnitOptions);
    }

    static class WithStepDescriptions
    extends ParentRunner<Step>
    implements PickleRunner {
        private final CucumberExecutionContext context;
        private final Pickle pickle;
        private final JUnitOptions jUnitOptions;
        private final Map<Step, Description> stepDescriptions = new HashMap<Step, Description>();
        private final Integer uniqueSuffix;
        private Description description;

        WithStepDescriptions(CucumberExecutionContext context, Pickle pickle, Integer uniqueSuffix, JUnitOptions jUnitOptions) throws InitializationError {
            super((Class)null);
            this.context = context;
            this.pickle = pickle;
            this.jUnitOptions = jUnitOptions;
            this.uniqueSuffix = uniqueSuffix;
        }

        protected List<Step> getChildren() {
            return new ArrayList<Step>(this.pickle.getSteps());
        }

        protected String getName() {
            return FileNameCompatibleNames.createName(this.pickle.getName(), this.uniqueSuffix, this.jUnitOptions.filenameCompatibleNames());
        }

        @Override
        public Description getDescription() {
            if (this.description == null) {
                this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)new PickleId(this.pickle), (Annotation[])new Annotation[0]);
                this.getChildren().forEach(step -> this.description.addChild(this.describeChild((Step)step)));
            }
            return this.description;
        }

        @Override
        public Description describeChild(Step step) {
            Description description = this.stepDescriptions.get(step);
            if (description == null) {
                String className = this.getName();
                String name = FileNameCompatibleNames.createName(step.getText(), this.jUnitOptions.filenameCompatibleNames());
                description = Description.createTestDescription((String)className, (String)name, (Serializable)new PickleStepId(this.pickle, step));
                this.stepDescriptions.put(step, description);
            }
            return description;
        }

        @Override
        public void run(RunNotifier notifier) {
            this.context.runTestCase(runner -> {
                JUnitReporter jUnitReporter = new JUnitReporter(runner.getBus(), this.jUnitOptions);
                jUnitReporter.startExecutionUnit(this, notifier);
                runner.runPickle(this.pickle);
                jUnitReporter.finishExecutionUnit();
            });
        }

        protected void runChild(Step step, RunNotifier notifier) {
            throw new UnsupportedOperationException();
        }
    }

    static final class NoStepDescriptions
    implements PickleRunner {
        private final String featureName;
        private final CucumberExecutionContext context;
        private final Pickle pickle;
        private final JUnitOptions jUnitOptions;
        private final Integer uniqueSuffix;
        private Description description;

        NoStepDescriptions(String featureName, CucumberExecutionContext context, Pickle pickle, Integer uniqueSuffix, JUnitOptions jUnitOptions) {
            this.featureName = featureName;
            this.context = context;
            this.pickle = pickle;
            this.jUnitOptions = jUnitOptions;
            this.uniqueSuffix = uniqueSuffix;
        }

        @Override
        public void run(RunNotifier notifier) {
            this.context.runTestCase(runner -> {
                JUnitReporter jUnitReporter = new JUnitReporter(runner.getBus(), this.jUnitOptions);
                jUnitReporter.startExecutionUnit(this, notifier);
                runner.runPickle(this.pickle);
                jUnitReporter.finishExecutionUnit();
            });
        }

        @Override
        public Description getDescription() {
            if (this.description == null) {
                String className = FileNameCompatibleNames.createName(this.featureName, this.jUnitOptions.filenameCompatibleNames());
                String name = FileNameCompatibleNames.createName(this.pickle.getName(), this.uniqueSuffix, this.jUnitOptions.filenameCompatibleNames());
                this.description = Description.createTestDescription((String)className, (String)name, (Serializable)new PickleId(this.pickle));
            }
            return this.description;
        }

        @Override
        public Description describeChild(Step step) {
            throw new UnsupportedOperationException("This pickle runner does not wish to describe its children");
        }
    }

    private static final class PickleStepId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final URI uri;
        private final int pickleLine;
        private final int pickleStepLine;

        PickleStepId(Pickle pickle, Step step) {
            this.uri = pickle.getUri();
            this.pickleLine = pickle.getLocation().getLine();
            this.pickleStepLine = step.getLine();
        }

        public int hashCode() {
            int result = this.pickleLine;
            result = 31 * result + this.uri.hashCode();
            result = 31 * result + this.pickleStepLine;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PickleStepId that = (PickleStepId)o;
            return this.pickleLine == that.pickleLine && this.pickleStepLine == that.pickleStepLine && this.uri.equals(that.uri);
        }

        public String toString() {
            return this.uri + ":" + this.pickleLine + ":" + this.pickleStepLine;
        }
    }

    static final class PickleId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final URI uri;
        private final int pickleLine;

        PickleId(Pickle pickle) {
            this(pickle.getUri(), pickle.getLocation().getLine());
        }

        PickleId(URI uri, int pickleLine) {
            this.uri = uri;
            this.pickleLine = pickleLine;
        }

        public int hashCode() {
            int result = this.uri.hashCode();
            result = 31 * result + this.pickleLine;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PickleId that = (PickleId)o;
            return this.pickleLine == that.pickleLine && this.uri.equals(that.uri);
        }

        public String toString() {
            return this.uri + ":" + this.pickleLine;
        }
    }

    static interface PickleRunner {
        public void run(RunNotifier var1);

        public Description getDescription();

        public Description describeChild(Step var1);
    }
}

