/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.jsonformatter;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TableRow;
import io.cucumber.query.LineageReducer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

final class IdNamingVisitor
implements LineageReducer.Collector<String> {
    private static final Pattern replacementPattern = Pattern.compile("[\\s'_,!]");
    private final List<String> parts = new ArrayList<String>();

    IdNamingVisitor() {
    }

    public void add(Feature feature) {
        this.parts.add(IdNamingVisitor.formatId(feature.getName()));
    }

    public void add(Rule rule) {
        this.parts.add(IdNamingVisitor.formatId(rule.getName()));
    }

    public void add(Scenario scenario) {
        this.parts.add(IdNamingVisitor.formatId(scenario.getName()));
    }

    public void add(Examples examples, int index) {
        this.parts.add(IdNamingVisitor.formatId(examples.getName()));
    }

    public void add(TableRow example, int index) {
        this.parts.add(String.valueOf(index + 2));
    }

    public String finish() {
        return String.join((CharSequence)";", this.parts);
    }

    static String formatId(String name) {
        return replacementPattern.matcher(name).replaceAll("-").toLowerCase(Locale.ROOT);
    }
}

