/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java.After;
import cucumber.api.java.Before;
import cucumber.api.java.ObjectFactory;
import cucumber.api.java8.GlueBase;
import cucumber.runtime.Backend;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.Env;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.Utils;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.java.Java8Snippet;
import cucumber.runtime.java.JavaHookDefinition;
import cucumber.runtime.java.JavaSnippet;
import cucumber.runtime.java.JavaStepDefinition;
import cucumber.runtime.java.LambdaGlueRegistry;
import cucumber.runtime.java.MethodScanner;
import cucumber.runtime.java.ObjectFactoryLoader;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.pickles.PickleStep;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class JavaBackend
implements Backend,
LambdaGlueRegistry {
    private final SnippetGenerator snippetGenerator = new SnippetGenerator(this.createSnippet());
    private final ObjectFactory objectFactory;
    private final ClassFinder classFinder;
    private final MethodScanner methodScanner;
    private Glue glue;
    private List<Class<? extends GlueBase>> glueBaseClasses = new ArrayList<Class<? extends GlueBase>>();

    private Snippet createSnippet() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass("cucumber.runtime.java8.LambdaGlueBase");
            return new Java8Snippet();
        }
        catch (ClassNotFoundException thatsOk) {
            return new JavaSnippet();
        }
    }

    public JavaBackend(ResourceLoader resourceLoader) {
        this((ClassFinder)new ResourceLoaderClassFinder(resourceLoader, Thread.currentThread().getContextClassLoader()));
    }

    private JavaBackend(ClassFinder classFinder) {
        this(ObjectFactoryLoader.loadObjectFactory(classFinder, Env.INSTANCE.get(ObjectFactory.class.getName())), classFinder);
    }

    public JavaBackend(ObjectFactory objectFactory, ClassFinder classFinder) {
        this.classFinder = classFinder;
        this.objectFactory = objectFactory;
        this.methodScanner = new MethodScanner(classFinder);
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        this.methodScanner.scan(this, gluePaths);
        for (String gluePath : gluePaths) {
            Collection glueDefinerClasses = this.classFinder.getDescendants(GlueBase.class, MultiLoader.packageName((String)gluePath));
            for (Class glueClass : glueDefinerClasses) {
                if (glueClass.isInterface() || !this.objectFactory.addClass(glueClass)) continue;
                this.glueBaseClasses.add(glueClass);
            }
        }
    }

    public void loadGlue(Glue glue, Method method, Class<?> glueCodeClass) {
        this.glue = glue;
        this.methodScanner.scan(this, method, glueCodeClass);
    }

    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    public void buildWorld() {
        this.objectFactory.start();
        try {
            INSTANCE.set(this);
            this.glue.removeScenarioScopedGlue();
            for (Class<? extends GlueBase> glueBaseClass : this.glueBaseClasses) {
                this.objectFactory.getInstance(glueBaseClass);
            }
        }
        finally {
            INSTANCE.remove();
        }
    }

    public void disposeWorld() {
        this.objectFactory.stop();
    }

    public String getSnippet(PickleStep step, String keyword, FunctionNameGenerator functionNameGenerator) {
        return this.snippetGenerator.getSnippet(step, keyword, functionNameGenerator);
    }

    void addStepDefinition(Annotation annotation, Method method) {
        try {
            if (this.objectFactory.addClass(method.getDeclaringClass())) {
                this.glue.addStepDefinition((StepDefinition)new JavaStepDefinition(method, this.pattern(annotation), this.timeoutMillis(annotation), this.objectFactory));
            }
        }
        catch (DuplicateStepDefinitionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CucumberException(e);
        }
    }

    @Override
    public void addStepDefinition(StepDefinition stepDefinition) {
        this.glue.addStepDefinition(stepDefinition);
    }

    void addHook(Annotation annotation, Method method) {
        if (this.objectFactory.addClass(method.getDeclaringClass())) {
            if (annotation.annotationType().equals(Before.class)) {
                String[] tagExpressions = ((Before)annotation).value();
                long timeout = ((Before)annotation).timeout();
                this.addBeforeHookDefinition(new JavaHookDefinition(method, tagExpressions, ((Before)annotation).order(), timeout, this.objectFactory));
            } else {
                String[] tagExpressions = ((After)annotation).value();
                long timeout = ((After)annotation).timeout();
                this.addAfterHookDefinition(new JavaHookDefinition(method, tagExpressions, ((After)annotation).order(), timeout, this.objectFactory));
            }
        }
    }

    @Override
    public void addBeforeHookDefinition(HookDefinition beforeHook) {
        this.glue.addBeforeHook(beforeHook);
    }

    @Override
    public void addAfterHookDefinition(HookDefinition afterHook) {
        this.glue.addAfterHook(afterHook);
    }

    private Pattern pattern(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("value", new Class[0]);
        String regexpString = (String)Utils.invoke((Object)annotation, (Method)regexpMethod, (long)0L, (Object[])new Object[0]);
        return Pattern.compile(regexpString);
    }

    private long timeoutMillis(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("timeout", new Class[0]);
        return (Long)Utils.invoke((Object)annotation, (Method)regexpMethod, (long)0L, (Object[])new Object[0]);
    }
}

