/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.Backend;
import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.CucumberInvocationTargetException;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.backend.Snippet;
import io.cucumber.core.backend.StaticHookDefinition;
import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.exception.ExceptionUtils;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.runner.AmbiguousPickleStepDefinitionsMatch;
import io.cucumber.core.runner.AmbiguousStepDefinitionsException;
import io.cucumber.core.runner.CachingGlue;
import io.cucumber.core.runner.CoreHookDefinition;
import io.cucumber.core.runner.HookDefinitionMatch;
import io.cucumber.core.runner.HookTestStep;
import io.cucumber.core.runner.Options;
import io.cucumber.core.runner.PickleStepDefinitionMatch;
import io.cucumber.core.runner.PickleStepTestStep;
import io.cucumber.core.runner.StackManipulation;
import io.cucumber.core.runner.TestCase;
import io.cucumber.core.runner.ThrowableCollector;
import io.cucumber.core.runner.UndefinedPickleStepDefinitionMatch;
import io.cucumber.core.snippets.SnippetGenerator;
import io.cucumber.core.stepexpression.StepTypeRegistry;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Suggestion;
import io.cucumber.plugin.event.HookType;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Runner {
    private static final Logger log = LoggerFactory.getLogger(Runner.class);
    private final CachingGlue glue;
    private final EventBus bus;
    private final Collection<? extends Backend> backends;
    private final Options runnerOptions;
    private final ObjectFactory objectFactory;
    private final Map<String, Locale> localeCache = new HashMap<String, Locale>();
    private List<SnippetGenerator> snippetGenerators;

    public Runner(EventBus bus, Collection<? extends Backend> backends, ObjectFactory objectFactory, Options runnerOptions) {
        this.bus = bus;
        this.runnerOptions = runnerOptions;
        this.backends = backends;
        this.glue = new CachingGlue(bus);
        this.objectFactory = objectFactory;
        List<URI> gluePaths = runnerOptions.getGlue();
        log.debug(() -> "Loading glue from " + gluePaths);
        for (Backend backend : backends) {
            log.debug(() -> "Loading glue for backend " + backend.getClass().getName());
            backend.loadGlue(this.glue, gluePaths);
        }
    }

    public EventBus getBus() {
        return this.bus;
    }

    public void runPickle(Pickle pickle) {
        try {
            this.buildBackendWorlds();
            this.glue.prepareGlue(this.localeForPickle(pickle));
            this.snippetGenerators = this.createSnippetGeneratorsForPickle(pickle.getLanguage(), this.glue.getStepTypeRegistry());
            TestCase testCase = this.createTestCaseForPickle(pickle);
            testCase.run(this.bus);
        }
        finally {
            this.glue.removeScenarioScopedGlue();
            this.disposeBackendWorlds();
        }
    }

    private Locale localeForPickle(Pickle pickle) {
        String language = pickle.getLanguage();
        return this.localeCache.computeIfAbsent(language, lang -> new Locale(language));
    }

    public void runBeforeAllHooks() {
        this.executeHooks(this.glue.getBeforeAllHooks());
    }

    public void runAfterAllHooks() {
        this.executeHooks(this.glue.getAfterAllHooks());
    }

    private void executeHooks(List<StaticHookDefinition> afterAllHooks) {
        ThrowableCollector throwableCollector = new ThrowableCollector();
        for (StaticHookDefinition staticHookDefinition : afterAllHooks) {
            throwableCollector.execute(() -> this.executeHook(staticHookDefinition));
        }
        Throwable throwable = throwableCollector.getThrowable();
        if (throwable != null) {
            ExceptionUtils.throwAsUncheckedException(throwable);
        }
    }

    private void executeHook(StaticHookDefinition hookDefinition) {
        if (this.runnerOptions.isDryRun()) {
            return;
        }
        try {
            hookDefinition.execute();
        }
        catch (CucumberBackendException e) {
            CucumberException exception = new CucumberException(String.format("Could not invoke hook defined at '%s'.\nIt appears there was a problem with the hook definition.", hookDefinition.getLocation()), e);
            ExceptionUtils.throwAsUncheckedException(exception);
        }
        catch (CucumberInvocationTargetException e) {
            Throwable throwable = StackManipulation.removeFrameworkFrames(e);
            ExceptionUtils.throwAsUncheckedException(throwable);
        }
    }

    private List<SnippetGenerator> createSnippetGeneratorsForPickle(String language, StepTypeRegistry stepTypeRegistry) {
        return this.backends.stream().map(Backend::getSnippet).filter(Objects::nonNull).map(s -> new SnippetGenerator(language, (Snippet)s, stepTypeRegistry.parameterTypeRegistry())).collect(Collectors.toList());
    }

    private void buildBackendWorlds() {
        this.objectFactory.start();
        for (Backend backend : this.backends) {
            backend.buildWorld();
        }
    }

    private TestCase createTestCaseForPickle(Pickle pickle) {
        if (pickle.getSteps().isEmpty()) {
            return new TestCase(this.bus.generateId(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), pickle, this.runnerOptions.isDryRun());
        }
        List<PickleStepTestStep> testSteps = this.createTestStepsForPickleSteps(pickle);
        List<HookTestStep> beforeHooks = this.createTestStepsForBeforeHooks(pickle.getTags());
        List<HookTestStep> afterHooks = this.createTestStepsForAfterHooks(pickle.getTags());
        return new TestCase(this.bus.generateId(), testSteps, beforeHooks, afterHooks, pickle, this.runnerOptions.isDryRun());
    }

    private void disposeBackendWorlds() {
        for (Backend backend : this.backends) {
            backend.disposeWorld();
        }
        this.objectFactory.stop();
    }

    private List<PickleStepTestStep> createTestStepsForPickleSteps(Pickle pickle) {
        ArrayList<PickleStepTestStep> testSteps = new ArrayList<PickleStepTestStep>();
        for (Step step : pickle.getSteps()) {
            PickleStepDefinitionMatch match = this.matchStepToStepDefinition(pickle, step);
            List<HookTestStep> afterStepHookSteps = this.createAfterStepHooks(pickle.getTags());
            List<HookTestStep> beforeStepHookSteps = this.createBeforeStepHooks(pickle.getTags());
            testSteps.add(new PickleStepTestStep(this.bus.generateId(), pickle.getUri(), step, beforeStepHookSteps, afterStepHookSteps, match));
        }
        return testSteps;
    }

    private List<HookTestStep> createTestStepsForBeforeHooks(List<String> tags) {
        return this.createTestStepsForHooks(tags, this.glue.getBeforeHooks(), HookType.BEFORE);
    }

    private List<HookTestStep> createTestStepsForAfterHooks(List<String> tags) {
        return this.createTestStepsForHooks(tags, this.glue.getAfterHooks(), HookType.AFTER);
    }

    private PickleStepDefinitionMatch matchStepToStepDefinition(Pickle pickle, Step step) {
        try {
            PickleStepDefinitionMatch match = this.glue.stepDefinitionMatch(pickle.getUri(), step);
            if (match != null) {
                return match;
            }
            this.emitSnippetSuggestedEvent(pickle, step);
            return new UndefinedPickleStepDefinitionMatch(pickle.getUri(), step);
        }
        catch (AmbiguousStepDefinitionsException e) {
            return new AmbiguousPickleStepDefinitionsMatch(pickle.getUri(), step, e);
        }
    }

    private void emitSnippetSuggestedEvent(Pickle pickle, Step step) {
        List<io.cucumber.messages.types.Snippet> snippets = this.generateSnippetsForStep(step);
        if (snippets.isEmpty()) {
            return;
        }
        this.bus.send(new SnippetsSuggestedEvent(this.bus.getInstant(), pickle.getUri(), pickle.getLocation(), step.getLocation(), new SnippetsSuggestedEvent.Suggestion(step.getText(), snippets.stream().map(io.cucumber.messages.types.Snippet::getCode).collect(Collectors.toList()))));
        this.bus.send(Envelope.of((Suggestion)new Suggestion(this.bus.generateId().toString(), step.getId(), snippets)));
    }

    private List<HookTestStep> createAfterStepHooks(List<String> tags) {
        return this.createTestStepsForHooks(tags, this.glue.getAfterStepHooks(), HookType.AFTER_STEP);
    }

    private List<HookTestStep> createBeforeStepHooks(List<String> tags) {
        return this.createTestStepsForHooks(tags, this.glue.getBeforeStepHooks(), HookType.BEFORE_STEP);
    }

    private List<HookTestStep> createTestStepsForHooks(List<String> tags, Collection<CoreHookDefinition> hooks, HookType hookType) {
        return hooks.stream().filter(hook -> hook.matches(tags)).map(hook -> new HookTestStep(this.bus.generateId(), hookType, new HookDefinitionMatch((CoreHookDefinition)hook))).collect(Collectors.toList());
    }

    private List<io.cucumber.messages.types.Snippet> generateSnippetsForStep(Step step) {
        return this.snippetGenerators.stream().flatMap(generator -> {
            String language = generator.getLanguage().orElse("unknown");
            return generator.getSnippet(step, this.runnerOptions.getSnippetType()).stream().map(code -> new io.cucumber.messages.types.Snippet(language, code));
        }).collect(Collectors.toList());
    }
}

