/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.internal.com.fasterxml.jackson.annotation.JsonInclude;
import io.cucumber.core.internal.com.fasterxml.jackson.core.JsonGenerator;
import io.cucumber.core.internal.com.fasterxml.jackson.databind.ObjectMapper;
import io.cucumber.core.internal.com.fasterxml.jackson.databind.SerializationFeature;
import io.cucumber.messages.Convertor;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleTag;
import io.cucumber.messages.types.TestCaseFinished;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.messages.types.Timestamp;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.query.Lineage;
import io.cucumber.query.Query;
import io.cucumber.query.Repository;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TimelineFormatter
implements ConcurrentEventListener {
    private static final String[] TEXT_ASSETS = new String[]{"/io/cucumber/core/plugin/timeline/index.html", "/io/cucumber/core/plugin/timeline/formatter.js", "/io/cucumber/core/plugin/timeline/report.css", "/io/cucumber/core/plugin/timeline/jquery-3.5.1.min.js", "/io/cucumber/core/plugin/timeline/vis-timeline-graph2d.min.css", "/io/cucumber/core/plugin/timeline/vis-timeline-graph2d.min.js", "/io/cucumber/core/plugin/timeline/vis-timeline-graph2d.override.css", "/io/cucumber/core/plugin/timeline/chosen.jquery.min.js", "/io/cucumber/core/plugin/timeline/chosen.min.css", "/io/cucumber/core/plugin/timeline/chosen.override.css", "/io/cucumber/core/plugin/timeline/chosen-sprite.png"};
    private final Repository repository = Repository.builder().feature(Repository.RepositoryFeature.INCLUDE_GHERKIN_DOCUMENTS, true).build();
    private final Query query = new Query(this.repository);
    private final File reportDir;
    private final ObjectMapper objectMapper = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Value.construct(JsonInclude.Include.NON_ABSENT, JsonInclude.Include.NON_ABSENT)).enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING).disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);

    public TimelineFormatter(File reportDir) throws FileNotFoundException {
        boolean dontCare = reportDir.mkdirs();
        if (!reportDir.isDirectory()) {
            throw new CucumberException(String.format("The %s needs an existing directory. Not a directory: %s", this.getClass().getName(), reportDir.getAbsolutePath()));
        }
        this.reportDir = reportDir;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, this::write);
    }

    private void write(Envelope event) {
        this.repository.update(event);
        if (event.getTestRunFinished().isPresent()) {
            try {
                this.writeTimeLineReport();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void writeTimeLineReport() throws IOException {
        HashMap timeLineGroupsById = new HashMap();
        List<TimeLineItem> timeLineItems = this.query.findAllTestCaseFinished().stream().map(testCaseFinished -> this.query.findTestCaseStartedBy(testCaseFinished).map(testCaseStarted -> this.createTestData((TestCaseFinished)testCaseFinished, (TestCaseStarted)testCaseStarted, this.createTimeLineGroup(timeLineGroupsById)))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List<TimeLineGroup> timeLineGroups = timeLineGroupsById.values().stream().sorted(Comparator.comparing(TimeLineGroup::getId)).collect(Collectors.toList());
        this.writeTimeLineReport(timeLineGroups, timeLineItems);
    }

    private Function<String, TimeLineGroup> createTimeLineGroup(Map<String, TimeLineGroup> timeLineGroups) {
        return workerId -> timeLineGroups.computeIfAbsent((String)workerId, this.createTimeLineGroup());
    }

    private Function<String, TimeLineGroup> createTimeLineGroup() {
        return workerId -> {
            TimeLineGroup timeLineGroup = new TimeLineGroup();
            timeLineGroup.setContent((String)workerId);
            timeLineGroup.setId((String)workerId);
            return timeLineGroup;
        };
    }

    private TimeLineItem createTestData(TestCaseFinished testCaseFinished, TestCaseStarted testCaseStarted, Function<String, TimeLineGroup> timeLineGroupCreator) {
        String workerId = testCaseStarted.getWorkerId().orElse("");
        TimeLineGroup timeLineGroup = timeLineGroupCreator.apply(workerId);
        return this.createTestData(testCaseFinished, testCaseStarted, timeLineGroup);
    }

    private TimeLineItem createTestData(TestCaseFinished testCaseFinished, TestCaseStarted testCaseStarted, TimeLineGroup timeLineGroup) {
        TimeLineItem data = new TimeLineItem();
        data.setId(testCaseStarted.getTestCaseId());
        data.setFeature(this.getFeatureName(testCaseStarted));
        data.setScenario(this.getPickleName(testCaseStarted));
        data.setStart(Convertor.toInstant((Timestamp)testCaseStarted.getTimestamp()).toEpochMilli());
        data.setTags(this.getTagsValue(testCaseStarted));
        data.setGroup(timeLineGroup.getId());
        data.setEnd(Convertor.toInstant((Timestamp)testCaseFinished.getTimestamp()).toEpochMilli());
        data.setClassName(this.getTestStepStatusResult(testCaseFinished));
        return data;
    }

    private String getTestStepStatusResult(TestCaseFinished event) {
        return this.query.findMostSevereTestStepResultBy(event).map(TestStepResult::getStatus).map(TestStepResultStatus::value).map(s -> s.toLowerCase(Locale.ROOT)).orElse("passed");
    }

    private String getPickleName(TestCaseStarted testCaseStarted) {
        return this.query.findPickleBy(testCaseStarted).map(Pickle::getName).orElse("");
    }

    private String getFeatureName(TestCaseStarted testCaseStarted) {
        return this.query.findLineageBy(testCaseStarted).flatMap(Lineage::feature).map(Feature::getName).orElse("");
    }

    private String getTagsValue(TestCaseStarted testCaseStarted) {
        return this.query.findPickleBy(testCaseStarted).map(pickle -> {
            StringBuilder tags = new StringBuilder();
            for (PickleTag tag : pickle.getTags()) {
                tags.append(tag.getName().toLowerCase()).append(",");
            }
            return tags.toString();
        }).orElse("");
    }

    private void writeTimeLineReport(List<TimeLineGroup> timeLineGroups, List<TimeLineItem> timeLineItems) throws IOException {
        this.writeReportJs(timeLineGroups, timeLineItems);
        this.copyReportFiles();
    }

    private void writeReportJs(List<TimeLineGroup> timeLineGroups, List<TimeLineItem> timeLineItems) throws IOException {
        File reportJsFile = new File(this.reportDir, "report.js");
        try (BufferedWriter reportJs = Files.newBufferedWriter(reportJsFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            reportJs.append("$(document).ready(function() {");
            reportJs.append("\n");
            this.appendAsJsonToJs(reportJs, "timelineItems", timeLineItems);
            reportJs.append("\n");
            this.appendAsJsonToJs(reportJs, "timelineGroups", timeLineGroups);
            reportJs.append("\n");
            reportJs.append("});");
        }
    }

    private void appendAsJsonToJs(BufferedWriter out, String pushTo, Collection<?> content) throws IOException {
        out.append("CucumberHTML.").append(pushTo).append(".pushArray(");
        this.objectMapper.writeValue(out, content);
        out.append(");");
    }

    private void copyReportFiles() throws IOException {
        if (this.reportDir == null) {
            return;
        }
        File outputDir = new File(this.reportDir.getPath());
        for (String textAsset : TEXT_ASSETS) {
            try (InputStream textAssetStream = this.getClass().getResourceAsStream(textAsset);){
                if (textAssetStream == null) {
                    throw new CucumberException("Couldn't find " + textAsset);
                }
                String fileName = new File(textAsset).getName();
                TimelineFormatter.copyFile(textAssetStream, new File(outputDir, fileName));
            }
        }
    }

    private static void copyFile(InputStream source, File dest) throws IOException {
        try (OutputStream os = Files.newOutputStream(dest.toPath(), new OpenOption[0]);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = source.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
    }

    static class TimeLineGroup {
        private String id;
        private String content;

        TimeLineGroup() {
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getId() {
            return this.id;
        }

        public String getContent() {
            return this.content;
        }
    }

    static class TimeLineItem {
        private String id;
        private String feature;
        private String scenario;
        private long start;
        private String group;
        private String content = "";
        private String tags;
        private long end;
        private String className;

        TimeLineItem() {
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setFeature(String feature) {
            this.feature = feature;
        }

        public void setScenario(String scenario) {
            this.scenario = scenario;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setTags(String tags) {
            this.tags = tags;
        }

        public void setEnd(long end) {
            this.end = end;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getId() {
            return this.id;
        }

        public String getFeature() {
            return this.feature;
        }

        public String getScenario() {
            return this.scenario;
        }

        public long getStart() {
            return this.start;
        }

        public String getGroup() {
            return this.group;
        }

        public String getContent() {
            return this.content;
        }

        public String getTags() {
            return this.tags;
        }

        public long getEnd() {
            return this.end;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

