/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.backend;

import io.cucumber.core.backend.SourceReference;
import java.util.Objects;
import java.util.Optional;

public class StackTraceElementReference
implements SourceReference {
    private final String className;
    private final String methodName;
    private final String fileName;
    private final int lineNumber;

    StackTraceElementReference(String className, String methodName, String fileName, int lineNumber) {
        this.className = Objects.requireNonNull(className);
        this.methodName = Objects.requireNonNull(methodName);
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public String className() {
        return this.className;
    }

    public String methodName() {
        return this.methodName;
    }

    public Optional<String> fileName() {
        return Optional.ofNullable(this.fileName);
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackTraceElementReference that = (StackTraceElementReference)o;
        return this.lineNumber == that.lineNumber && this.className.equals(that.className) && this.methodName.equals(that.methodName) && Objects.equals(this.fileName, that.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.methodName, this.fileName, this.lineNumber);
    }
}

