/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.storage.encoder;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.JsonKeysetWriter;
import com.google.crypto.tink.KeysetHandle;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.encoder.KeysetWrapper;
import io.confluent.kafka.schemaregistry.storage.encoder.MetadataEncoderService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

public class KeysetWrapperSerializer
implements Serializer<KeysetWrapper> {
    private Aead aead;

    public KeysetWrapperSerializer(SchemaRegistryConfig config) {
        try {
            String secret = MetadataEncoderService.encoderSecret(config);
            this.aead = MetadataEncoderService.getPrimitive(secret);
        }
        catch (GeneralSecurityException e) {
            throw new ConfigException("Error while configuring KeysetWrapperSerializer", (Object)e);
        }
    }

    public byte[] serialize(String topic, KeysetWrapper key) {
        try {
            KeysetHandle keysetHandle = key.getKeysetHandle();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            keysetHandle.write(JsonKeysetWriter.withOutputStream((OutputStream)baos), this.aead);
            return baos.toByteArray();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new SerializationException("Error while serializing KeysetWrapper", (Throwable)e);
        }
    }
}

