/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.client.rest.entities.LifecyclePolicy;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.AssociationCreateOrUpdateInfo;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Association {
    private String subject;
    private String guid;
    private String resourceName;
    private String resourceNamespace;
    private String resourceId;
    private String resourceType;
    private String associationType;
    private LifecyclePolicy lifecycle;
    private boolean frozen;

    @JsonCreator
    public Association(@JsonProperty(value="subject") String subject, @JsonProperty(value="guid") String guid, @JsonProperty(value="resourceName") String resourceName, @JsonProperty(value="resourceNamespace") String resourceNamespace, @JsonProperty(value="resourceId") String resourceId, @JsonProperty(value="resourceType") String resourceType, @JsonProperty(value="associationType") String associationType, @JsonProperty(value="lifecycle") LifecyclePolicy lifecycle, @JsonProperty(value="frozen") boolean frozen) {
        this.subject = subject;
        this.guid = guid;
        this.resourceName = resourceName;
        this.resourceNamespace = resourceNamespace;
        this.resourceId = resourceId;
        this.resourceType = resourceType;
        this.associationType = associationType;
        this.lifecycle = lifecycle;
        this.frozen = frozen;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty(value="guid")
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    public void setGuid(String guid) {
        this.guid = guid;
    }

    @JsonProperty(value="resourceName")
    public String getResourceName() {
        return this.resourceName;
    }

    @JsonProperty(value="resourceName")
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @JsonProperty(value="resourceNamespace")
    public String getResourceNamespace() {
        return this.resourceNamespace;
    }

    @JsonProperty(value="resourceNamespace")
    public void setResourceNamespace(String resourceNamespace) {
        this.resourceNamespace = resourceNamespace;
    }

    @JsonProperty(value="resourceId")
    public String getResourceId() {
        return this.resourceId;
    }

    @JsonProperty(value="resourceId")
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @JsonProperty(value="resourceType")
    public String getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="resourceType")
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @JsonProperty(value="associationType")
    public String getAssociationType() {
        return this.associationType;
    }

    @JsonProperty(value="associationType")
    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    @JsonProperty(value="lifecycle")
    public LifecyclePolicy getLifecycle() {
        return this.lifecycle;
    }

    @JsonProperty(value="lifecycle")
    public void setLifecycle(LifecyclePolicy lifecycle) {
        this.lifecycle = lifecycle;
    }

    @JsonProperty(value="frozen")
    public boolean isFrozen() {
        return this.frozen;
    }

    @JsonProperty(value="frozen")
    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Association that = (Association)o;
        return this.frozen == that.frozen && Objects.equals(this.subject, that.subject) && Objects.equals(this.guid, that.guid) && Objects.equals(this.resourceName, that.resourceName) && Objects.equals(this.resourceNamespace, that.resourceNamespace) && Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.associationType, that.associationType) && this.lifecycle == that.lifecycle;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.subject, this.guid, this.resourceName, this.resourceNamespace, this.resourceId, this.resourceType, this.associationType, this.lifecycle, this.frozen});
    }

    public boolean isEquivalent(AssociationCreateOrUpdateInfo info) {
        return !(!Objects.equals(this.subject, info.getSubject()) || !Objects.equals(this.associationType, info.getAssociationType()) || info.getLifecycle() != null && !Objects.equals((Object)info.getLifecycle(), (Object)this.getLifecycle()) || info.getFrozen() != null && !Objects.equals(info.getFrozen(), this.isFrozen()));
    }
}

