/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import io.confluent.kafka.schemaregistry.CompatibilityLevel;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.ParsedSchemaHolder;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.SimpleParsedSchemaHolder;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.Association;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.LifecyclePolicy;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryDeployment;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.AssociationCreateOrUpdateInfo;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.AssociationCreateOrUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.AssociationInfo;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.AssociationResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSchemaRegistryClient
implements SchemaRegistryClient {
    private static final Logger log = LoggerFactory.getLogger(MockSchemaRegistryClient.class);
    private static final int DEFAULT_CAPACITY = 1000;
    private static final String WILDCARD = "*";
    private static final String DEFAULT_RESOURCE_TYPE = "topic";
    private static final String DEFAULT_ASSOCIATION_TYPE = "value";
    private static final LifecyclePolicy DEFAULT_LIFECYCLE_POLICY = LifecyclePolicy.STRONG;
    private static final Map<String, List<String>> RESOURCE_TYPE_TO_ASSOC_TYPE_MAP = new HashMap<String, List<String>>(){
        {
            this.put(MockSchemaRegistryClient.DEFAULT_RESOURCE_TYPE, Arrays.asList("key", MockSchemaRegistryClient.DEFAULT_ASSOCIATION_TYPE));
        }
    };
    private Config defaultConfig = new Config("BACKWARD");
    private final Map<String, Map<ParsedSchema, RegisterSchemaResponse>> schemaToResponseCache = new ConcurrentHashMap<String, Map<ParsedSchema, RegisterSchemaResponse>>();
    private final Map<String, Map<ParsedSchema, Integer>> registeredSchemaCache = new ConcurrentHashMap<String, Map<ParsedSchema, Integer>>();
    private final Map<String, Map<Integer, ParsedSchema>> idToSchemaCache = new ConcurrentHashMap<String, Map<Integer, ParsedSchema>>();
    private final Map<String, ParsedSchema> guidToSchemaCache = new ConcurrentHashMap<String, ParsedSchema>();
    private final Map<String, Map<ParsedSchema, Integer>> schemaToVersionCache = new ConcurrentHashMap<String, Map<ParsedSchema, Integer>>();
    private final Map<String, Config> configCache = new ConcurrentHashMap<String, Config>();
    private final Map<String, List<Association>> subjectToAssocCache = new ConcurrentHashMap<String, List<Association>>();
    private final Map<ResourceAndAssocType, Association> resourceAndAssocTypeCache = new ConcurrentHashMap<ResourceAndAssocType, Association>();
    private final Map<String, List<Association>> resourceIdToAssocCache = new ConcurrentHashMap<String, List<Association>>();
    private final Map<String, String> modes = new ConcurrentHashMap<String, String>();
    private final Map<String, AtomicInteger> ids = new ConcurrentHashMap<String, AtomicInteger>();
    private final LoadingCache<Schema, ParsedSchema> parsedSchemaCache;
    private final Map<String, SchemaProvider> providers;
    private static final String NO_SUBJECT = "";

    public MockSchemaRegistryClient() {
        this(null);
    }

    public MockSchemaRegistryClient(List<SchemaProvider> providers) {
        this.providers = providers != null && !providers.isEmpty() ? providers.stream().collect(Collectors.toMap(SchemaProvider::schemaType, p -> p)) : Collections.singletonMap("AVRO", new AvroSchemaProvider());
        HashMap<String, MockSchemaRegistryClient> schemaProviderConfigs = new HashMap<String, MockSchemaRegistryClient>();
        schemaProviderConfigs.put("schemaVersionFetcher", this);
        for (SchemaProvider provider : this.providers.values()) {
            provider.configure(schemaProviderConfigs);
        }
        final Map<String, SchemaProvider> schemaProviders = this.providers;
        this.parsedSchemaCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Schema, ParsedSchema>(){

            public ParsedSchema load(Schema schema) throws Exception {
                SchemaProvider schemaProvider;
                String schemaType = schema.getSchemaType();
                if (schemaType == null) {
                    schemaType = "AVRO";
                }
                if ((schemaProvider = (SchemaProvider)schemaProviders.get(schemaType)) == null) {
                    log.error("Invalid schema type {}", (Object)schemaType);
                    throw new IllegalStateException("Invalid schema type " + schemaType);
                }
                return schemaProvider.parseSchema(schema, false, false).orElseThrow(() -> new IOException("Invalid schema of type " + schema.getSchemaType()));
            }
        });
    }

    @Override
    public Optional<ParsedSchema> parseSchema(String schemaType, String schemaString, List<SchemaReference> references) {
        return this.parseSchema(new Schema(null, null, null, schemaType, references, schemaString));
    }

    @Override
    public Optional<ParsedSchema> parseSchema(Schema schema) {
        try {
            return Optional.of((ParsedSchema)this.parsedSchemaCache.get((Object)schema));
        }
        catch (ExecutionException e) {
            return Optional.empty();
        }
    }

    private int getIdFromRegistry(String subject, ParsedSchema schema, boolean registerRequest, int id) throws RestClientException {
        Map idSchemaMap = this.idToSchemaCache.computeIfAbsent(subject, k -> new ConcurrentHashMap());
        if (!idSchemaMap.isEmpty()) {
            for (Map.Entry entry : idSchemaMap.entrySet()) {
                if (!this.schemasEqual((ParsedSchema)entry.getValue(), schema)) continue;
                if (registerRequest) {
                    if (id >= 0 && id != (Integer)entry.getKey()) continue;
                    this.generateVersion(subject, schema);
                }
                return (Integer)entry.getKey();
            }
        } else if (!registerRequest) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        if (registerRequest) {
            int schemaId;
            String context = MockSchemaRegistryClient.toQualifiedContext(subject);
            Map schemaIdMap = this.registeredSchemaCache.computeIfAbsent(context, k -> new ConcurrentHashMap());
            if (id >= 0) {
                schemaId = id;
                schemaIdMap.put(schema, schemaId);
            } else {
                schemaId = schemaIdMap.computeIfAbsent(schema, k -> this.ids.computeIfAbsent(context, c -> new AtomicInteger(0)).incrementAndGet());
            }
            this.generateVersion(subject, schema);
            idSchemaMap.put(schemaId, schema);
            return schemaId;
        }
        throw new RestClientException("Schema Not Found", 404, 40403);
    }

    private boolean schemasEqual(ParsedSchema schema1, ParsedSchema schema2) {
        return schema1.canonicalString().equals(schema2.canonicalString()) || schema1.canLookup(schema2, this);
    }

    private void generateVersion(String subject, ParsedSchema schema) {
        List<Integer> versions = this.allVersions(subject);
        int currentVersion = versions.isEmpty() ? 1 : versions.get(versions.size() - 1) + 1;
        Map schemaVersionMap = this.schemaToVersionCache.computeIfAbsent(subject, k -> new ConcurrentHashMap());
        schemaVersionMap.put(schema, currentVersion);
    }

    private ParsedSchema getSchemaBySubjectAndIdFromRegistry(String subject, int id) throws RestClientException {
        ParsedSchema schema;
        ParsedSchema schema2;
        Map<Integer, ParsedSchema> idSchemaMap = this.idToSchemaCache.get(subject);
        if (idSchemaMap != null && (schema2 = idSchemaMap.get(id)) != null) {
            return schema2;
        }
        String context = MockSchemaRegistryClient.toQualifiedContext(subject);
        if (!context.equals(subject) && (idSchemaMap = this.idToSchemaCache.get(context)) != null && (schema = idSchemaMap.get(id)) != null) {
            return schema;
        }
        throw new RestClientException("Subject Not Found", 404, 40401);
    }

    @Override
    public int register(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.register(subject, schema, 0, -1);
    }

    @Override
    public int register(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.registerWithResponse(subject, schema, 0, -1, normalize, false).getId();
    }

    @Override
    public int register(String subject, ParsedSchema schema, int version, int id) throws IOException, RestClientException {
        return this.registerWithResponse(subject, schema, version, id, false, false).getId();
    }

    @Override
    public RegisterSchemaResponse registerWithResponse(String subject, ParsedSchema schema, boolean normalize, boolean propagateSchemaTags) throws RestClientException {
        return this.registerWithResponse(subject, schema, 0, -1, normalize, propagateSchemaTags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisterSchemaResponse registerWithResponse(String subject, ParsedSchema schema, int version, int id, boolean normalize, boolean propagateSchemaTags) throws RestClientException {
        Map schemaResponseMap;
        RegisterSchemaResponse schemaResponse;
        if (normalize) {
            schema = schema.normalize();
        }
        if ((schemaResponse = (RegisterSchemaResponse)(schemaResponseMap = this.schemaToResponseCache.computeIfAbsent(subject, k -> new ConcurrentHashMap())).get(schema)) != null && (id < 0 || id == schemaResponse.getId())) {
            return schemaResponse;
        }
        MockSchemaRegistryClient mockSchemaRegistryClient = this;
        synchronized (mockSchemaRegistryClient) {
            schemaResponse = (RegisterSchemaResponse)schemaResponseMap.get(schema);
            if (schemaResponse != null && (id < 0 || id == schemaResponse.getId())) {
                return schemaResponse;
            }
            int retrievedId = this.getIdFromRegistry(subject, schema, true, id);
            Schema schemaEntity = new Schema(subject, (Integer)version, (Integer)retrievedId, schema);
            schemaResponse = new RegisterSchemaResponse(schemaEntity);
            schemaResponseMap.put(schema, schemaResponse);
            String context = MockSchemaRegistryClient.toQualifiedContext(subject);
            Map idSchemaMap = this.idToSchemaCache.computeIfAbsent(context, k -> new ConcurrentHashMap());
            idSchemaMap.put(retrievedId, schema);
            this.guidToSchemaCache.put(schemaEntity.getGuid(), schema);
            return schemaResponse;
        }
    }

    @Override
    public ParsedSchema getSchemaById(int id) throws IOException, RestClientException {
        return this.getSchemaBySubjectAndId(NO_SUBJECT, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParsedSchema getSchemaBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        Map idSchemaMap;
        ParsedSchema schema;
        if (subject == null) {
            subject = NO_SUBJECT;
        }
        if ((schema = (ParsedSchema)(idSchemaMap = this.idToSchemaCache.computeIfAbsent(subject, k -> new ConcurrentHashMap())).get(id)) != null) {
            return schema;
        }
        MockSchemaRegistryClient mockSchemaRegistryClient = this;
        synchronized (mockSchemaRegistryClient) {
            schema = (ParsedSchema)idSchemaMap.get(id);
            if (schema != null) {
                return schema;
            }
            ParsedSchema retrievedSchema = this.getSchemaBySubjectAndIdFromRegistry(subject, id);
            idSchemaMap.put(id, retrievedSchema);
            return retrievedSchema;
        }
    }

    @Override
    public ParsedSchema getSchemaByGuid(String guid, String format) throws IOException, RestClientException {
        return this.guidToSchemaCache.get(guid);
    }

    private Stream<ParsedSchema> getSchemasForSubject(String subject, boolean latestOnly) {
        try {
            List<Integer> versions = this.getAllVersions(subject);
            if (latestOnly) {
                int length = versions.size();
                versions = versions.subList(length - 1, length);
            }
            LinkedList<SchemaMetadata> schemaMetadata = new LinkedList<SchemaMetadata>();
            for (Integer version : versions) {
                schemaMetadata.add(this.getSchemaMetadata(subject, version));
            }
            LinkedList<ParsedSchema> schemas = new LinkedList<ParsedSchema>();
            for (SchemaMetadata metadata : schemaMetadata) {
                schemas.add(this.getSchemaBySubjectAndId(subject, metadata.getId()));
            }
            return schemas.stream();
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ParsedSchema> getSchemas(String subjectPrefix, boolean lookupDeletedSchema, boolean latestOnly) throws IOException, RestClientException {
        Stream<String> validSubjects = this.getAllSubjects().stream().filter(subject -> subject.startsWith(subjectPrefix));
        return validSubjects.flatMap(subject -> this.getSchemasForSubject((String)subject, latestOnly)).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getAllSubjectsById(int id) {
        return this.idToSchemaCache.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(id)).map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Collection<SubjectVersion> getAllVersionsById(int id) {
        return this.idToSchemaCache.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(id)).flatMap(e -> {
            ParsedSchema schema = (ParsedSchema)((Map)e.getValue()).get(id);
            Map<ParsedSchema, Integer> schemaVersionMap = this.schemaToVersionCache.get(e.getKey());
            if (schemaVersionMap != null) {
                int version = schemaVersionMap.get(schema);
                return Stream.of(new SubjectVersion((String)e.getKey(), version));
            }
            return Stream.empty();
        }).distinct().collect(Collectors.toList());
    }

    private int getLatestVersion(String subject) throws IOException, RestClientException {
        List<Integer> versions = this.getAllVersions(subject);
        if (versions.isEmpty()) {
            throw new IOException("No schema registered under subject!");
        }
        return versions.get(versions.size() - 1);
    }

    @Override
    public Schema getByVersion(String subject, int version, boolean lookupDeletedSchema) {
        ParsedSchema schema = null;
        Map<ParsedSchema, Integer> schemaVersionMap = this.schemaToVersionCache.get(subject);
        if (schemaVersionMap == null) {
            throw new RuntimeException(new RestClientException("Subject Not Found", 404, 40401));
        }
        int maxVersion = -1;
        for (Map.Entry<ParsedSchema, Integer> entry : schemaVersionMap.entrySet()) {
            if (version == -1) {
                if (entry.getValue() <= maxVersion) continue;
                schema = entry.getKey();
                maxVersion = entry.getValue();
                continue;
            }
            if (entry.getValue() != version) continue;
            schema = entry.getKey();
        }
        if (schema == null) {
            throw new RuntimeException(new RestClientException("Subject Not Found", 404, 40401));
        }
        if (maxVersion != -1) {
            version = maxVersion;
        }
        int id = -1;
        Map<Integer, ParsedSchema> idSchemaMap = this.idToSchemaCache.get(subject);
        for (Map.Entry<Integer, ParsedSchema> entry : idSchemaMap.entrySet()) {
            if (!this.schemasEqual(entry.getValue(), schema)) continue;
            id = entry.getKey();
        }
        return new Schema(subject, (Integer)version, (Integer)id, schema);
    }

    @Override
    public SchemaMetadata getSchemaMetadata(String subject, int version) throws IOException, RestClientException {
        return this.getSchemaMetadata(subject, version, false);
    }

    @Override
    public SchemaMetadata getSchemaMetadata(String subject, int version, boolean lookupDeletedSchema) throws RestClientException {
        ParsedSchema schema = null;
        Map<ParsedSchema, Integer> schemaVersionMap = this.schemaToVersionCache.get(subject);
        if (schemaVersionMap == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        for (Map.Entry<ParsedSchema, Integer> entry : schemaVersionMap.entrySet()) {
            if (entry.getValue() != version) continue;
            schema = entry.getKey();
        }
        if (schema == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        int id = -1;
        Map<Integer, ParsedSchema> idSchemaMap = this.idToSchemaCache.get(subject);
        for (Map.Entry<Integer, ParsedSchema> entry : idSchemaMap.entrySet()) {
            if (!this.schemasEqual(entry.getValue(), schema)) continue;
            id = entry.getKey();
        }
        return new SchemaMetadata(new Schema(subject, (Integer)version, (Integer)id, schema));
    }

    @Override
    public SchemaMetadata getLatestSchemaMetadata(String subject) throws IOException, RestClientException {
        int version = this.getLatestVersion(subject);
        return this.getSchemaMetadata(subject, version);
    }

    @Override
    public SchemaMetadata getLatestWithMetadata(String subject, Map<String, String> metadata, boolean lookupDeletedSchema) throws IOException, RestClientException {
        Map<ParsedSchema, Integer> versions = this.schemaToVersionCache.get(subject);
        TreeMap reverseMap = new TreeMap(Collections.reverseOrder());
        for (Map.Entry<ParsedSchema, Integer> entry : versions.entrySet()) {
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<ParsedSchema, Integer> entry : reverseMap.entrySet()) {
            SortedMap<String, String> props;
            Integer version = (Integer)((Object)entry.getKey());
            ParsedSchema schema = (ParsedSchema)((Object)entry.getValue());
            Metadata schemaMetadata = schema.metadata();
            if (schemaMetadata == null || (props = schemaMetadata.getProperties()) == null || !props.entrySet().containsAll(metadata.entrySet())) continue;
            int id = -1;
            Map<Integer, ParsedSchema> idSchemaMap = this.idToSchemaCache.get(subject);
            for (Map.Entry<Integer, ParsedSchema> e : idSchemaMap.entrySet()) {
                if (!this.schemasEqual(e.getValue(), schema)) continue;
                id = e.getKey();
            }
            return new SchemaMetadata(new Schema(subject, version, (Integer)id, schema));
        }
        throw new RestClientException("Schema Not Found", 404, 40403);
    }

    @Override
    public int getVersion(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getVersion(subject, schema, false);
    }

    @Override
    public int getVersion(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Map<ParsedSchema, Integer> versions;
        if (normalize) {
            schema = schema.normalize();
        }
        if ((versions = this.schemaToVersionCache.get(subject)) != null && versions.containsKey(schema)) {
            return versions.get(schema);
        }
        throw new RestClientException("Subject Not Found", 404, 40401);
    }

    @Override
    public List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        List<Integer> allVersions = this.allVersions(subject);
        if (!allVersions.isEmpty()) {
            return allVersions;
        }
        throw new RestClientException("Subject Not Found", 404, 40401);
    }

    private List<Integer> allVersions(String subject) {
        ArrayList<Integer> allVersions = new ArrayList<Integer>();
        Map<ParsedSchema, Integer> versions = this.schemaToVersionCache.get(subject);
        if (versions != null) {
            allVersions.addAll(versions.values());
            Collections.sort(allVersions);
        }
        return allVersions;
    }

    private int latestVersion(String subject) {
        List<Integer> versions = this.allVersions(subject);
        if (versions.isEmpty()) {
            return -1;
        }
        return versions.get(versions.size() - 1);
    }

    @Override
    public boolean testCompatibility(String subject, ParsedSchema newSchema) throws IOException, RestClientException {
        CompatibilityLevel compatibilityLevel;
        Config config = this.configCache.get(subject);
        if (config == null) {
            config = this.defaultConfig;
        }
        if ((compatibilityLevel = CompatibilityLevel.forName(config.getCompatibilityLevel())) == null) {
            return false;
        }
        ArrayList<ParsedSchemaHolder> schemaHistory = new ArrayList<ParsedSchemaHolder>();
        for (int version : this.allVersions(subject)) {
            SchemaMetadata schemaMetadata = this.getSchemaMetadata(subject, version);
            schemaHistory.add(new SimpleParsedSchemaHolder(this.getSchemaBySubjectAndIdFromRegistry(subject, schemaMetadata.getId())));
        }
        return newSchema.isCompatible(compatibilityLevel, schemaHistory).isEmpty();
    }

    @Override
    public int getId(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getId(subject, schema, false);
    }

    @Override
    public int getId(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.getIdWithResponse(subject, schema, normalize).getId();
    }

    @Override
    public String getGuid(String subject, ParsedSchema schema) throws IOException, RestClientException {
        return this.getGuid(subject, schema, false);
    }

    @Override
    public String getGuid(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        return this.getIdWithResponse(subject, schema, normalize).getGuid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterSchemaResponse getIdWithResponse(String subject, ParsedSchema schema, boolean normalize) throws IOException, RestClientException {
        Map schemaResponseMap;
        RegisterSchemaResponse schemaResponse;
        if (normalize) {
            schema = schema.normalize();
        }
        if ((schemaResponse = (RegisterSchemaResponse)(schemaResponseMap = this.schemaToResponseCache.computeIfAbsent(subject, k -> new ConcurrentHashMap())).get(schema)) != null) {
            return schemaResponse;
        }
        MockSchemaRegistryClient mockSchemaRegistryClient = this;
        synchronized (mockSchemaRegistryClient) {
            schemaResponse = (RegisterSchemaResponse)schemaResponseMap.get(schema);
            if (schemaResponse != null) {
                return schemaResponse;
            }
            int retrievedId = this.getIdFromRegistry(subject, schema, false, -1);
            Schema schemaEntity = new Schema(subject, null, (Integer)retrievedId, schema);
            schemaResponse = new RegisterSchemaResponse(schemaEntity);
            schemaResponseMap.put(schema, schemaResponse);
            String context = MockSchemaRegistryClient.toQualifiedContext(subject);
            Map idSchemaMap = this.idToSchemaCache.computeIfAbsent(context, k -> new ConcurrentHashMap());
            idSchemaMap.put(retrievedId, schema);
            return schemaResponse;
        }
    }

    @Override
    public List<Integer> deleteSubject(String subject, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSubject(null, subject, isPermanent);
    }

    @Override
    public synchronized List<Integer> deleteSubject(Map<String, String> requestProperties, String subject, boolean isPermanent) throws IOException, RestClientException {
        List<Association> associations = this.getAssociationsBySubject(subject, null, null, null, 0, -1);
        if (!associations.isEmpty()) {
            throw new RestClientException("Associations found", 409, 40921);
        }
        return this.deleteSubjectNoAssociationsCheck(requestProperties, subject, isPermanent);
    }

    private List<Integer> deleteSubjectNoAssociationsCheck(Map<String, String> requestProperties, String subject, boolean isPermanent) throws IOException, RestClientException {
        this.schemaToResponseCache.remove(subject);
        this.idToSchemaCache.remove(subject);
        Map<ParsedSchema, Integer> versions = this.schemaToVersionCache.remove(subject);
        this.configCache.remove(subject);
        return versions != null ? versions.values().stream().sorted().collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public Integer deleteSchemaVersion(String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        return this.deleteSchemaVersion(null, subject, version, isPermanent);
    }

    @Override
    public synchronized Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version, boolean isPermanent) throws IOException, RestClientException {
        Map<ParsedSchema, Integer> schemaVersionMap = this.schemaToVersionCache.get(subject);
        if (schemaVersionMap != null) {
            for (Map.Entry<ParsedSchema, Integer> entry : schemaVersionMap.entrySet()) {
                if (!entry.getValue().equals(Integer.valueOf(version))) continue;
                schemaVersionMap.values().remove(entry.getValue());
                if (isPermanent) {
                    this.idToSchemaCache.get(subject).remove(entry.getValue());
                    this.schemaToResponseCache.get(subject).remove(entry.getKey());
                }
                return Integer.valueOf(version);
            }
        }
        return -1;
    }

    @Override
    public List<String> testCompatibilityVerbose(String subject, ParsedSchema newSchema) throws IOException, RestClientException {
        CompatibilityLevel compatibilityLevel;
        Config config = this.configCache.get(subject);
        if (config == null) {
            config = this.defaultConfig;
        }
        if ((compatibilityLevel = CompatibilityLevel.forName(config.getCompatibilityLevel())) == null) {
            return Lists.newArrayList((Object[])new String[]{"Compatibility level not specified."});
        }
        ArrayList<ParsedSchemaHolder> schemaHistory = new ArrayList<ParsedSchemaHolder>();
        for (int version : this.allVersions(subject)) {
            SchemaMetadata schemaMetadata = this.getSchemaMetadata(subject, version);
            schemaHistory.add(new SimpleParsedSchemaHolder(this.getSchemaBySubjectAndIdFromRegistry(subject, schemaMetadata.getId())));
        }
        return newSchema.isCompatible(compatibilityLevel, schemaHistory);
    }

    @Override
    public Config updateConfig(String subject, Config config) throws IOException, RestClientException {
        if (subject == null) {
            this.defaultConfig = config;
            return config;
        }
        this.configCache.put(subject, config);
        return config;
    }

    @Override
    public Config getConfig(String subject) throws IOException, RestClientException {
        if (subject == null) {
            return this.defaultConfig;
        }
        Config config = this.configCache.get(subject);
        if (config == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        return config;
    }

    @Override
    public String setMode(String mode) throws IOException, RestClientException {
        this.modes.put(WILDCARD, mode);
        return mode;
    }

    @Override
    public String setMode(String mode, String subject) throws IOException, RestClientException {
        this.modes.put(subject, mode);
        return mode;
    }

    @Override
    public String setMode(String mode, String subject, boolean force) throws IOException, RestClientException {
        this.modes.put(subject, mode);
        return mode;
    }

    @Override
    public String getMode() throws IOException, RestClientException {
        return this.modes.getOrDefault(WILDCARD, "READWRITE");
    }

    @Override
    public String getMode(String subject) throws IOException, RestClientException {
        String mode = this.modes.get(subject);
        if (mode == null) {
            throw new RestClientException("Subject Not Found", 404, 40401);
        }
        return mode;
    }

    @Override
    public Collection<String> getAllContexts() throws IOException, RestClientException {
        List<String> results = new ArrayList<String>(this.schemaToResponseCache.keySet()).stream().map(s -> QualifiedSubject.create("default", s).getContext()).sorted().distinct().collect(Collectors.toList());
        return results;
    }

    @Override
    public SchemaRegistryDeployment getSchemaRegistryDeployment() throws IOException, RestClientException {
        return new SchemaRegistryDeployment();
    }

    @Override
    public Collection<String> getAllSubjects() throws IOException, RestClientException {
        ArrayList<String> results = new ArrayList<String>(this.schemaToResponseCache.keySet());
        Collections.sort(results);
        return results;
    }

    @Override
    public Collection<String> getAllSubjectsByPrefix(String subjectPrefix) throws IOException, RestClientException {
        Stream<String> validSubjects = this.getAllSubjects().stream().filter(subject -> subjectPrefix == null || subject.startsWith(subjectPrefix));
        return validSubjects.collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public synchronized void reset() {
        this.schemaToResponseCache.clear();
        this.registeredSchemaCache.clear();
        this.idToSchemaCache.clear();
        this.guidToSchemaCache.clear();
        this.schemaToVersionCache.clear();
        this.configCache.clear();
        this.modes.clear();
        this.ids.clear();
    }

    private static String toQualifiedContext(String subject) {
        QualifiedSubject qualifiedSubject = QualifiedSubject.create("default", subject);
        return qualifiedSubject != null ? qualifiedSubject.toQualifiedContext() : NO_SUBJECT;
    }

    private boolean validateResourceTypeAndAssociationType(String resourceType, String associationType) {
        if (!RESOURCE_TYPE_TO_ASSOC_TYPE_MAP.containsKey(resourceType)) {
            return false;
        }
        return RESOURCE_TYPE_TO_ASSOC_TYPE_MAP.get(resourceType).contains(associationType);
    }

    private synchronized void createAssociationsHelper(AssociationCreateOrUpdateRequest request) throws IOException, RestClientException {
        ResourceAndAssocType key;
        String subject;
        HashMap<String, AssociationCreateOrUpdateInfo> infosByType = new HashMap<String, AssociationCreateOrUpdateInfo>();
        for (AssociationCreateOrUpdateInfo info : request.getAssociations()) {
            String associationType = info.getAssociationType();
            if (infosByType.containsKey(associationType)) {
                throw new RestClientException(String.format("The association specified an invalid value for property: %s", associationType), 422, 42212);
            }
            infosByType.put(associationType, info);
        }
        for (AssociationCreateOrUpdateInfo associationInRequest : request.getAssociations()) {
            subject = associationInRequest.getSubject();
            int latestVersion = this.latestVersion(subject);
            if (associationInRequest.getSchema() != null || latestVersion >= 0) continue;
            throw new RestClientException(String.format("No active (non-deleted) version exists for subject '%s", subject), 409, 40907);
        }
        for (AssociationCreateOrUpdateInfo associationInRequest : request.getAssociations()) {
            key = new ResourceAndAssocType(request.getResourceId(), request.getResourceType(), associationInRequest.getAssociationType());
            Association existingAssociation = this.resourceAndAssocTypeCache.get(key);
            if (existingAssociation != null) {
                if (existingAssociation.getResourceName().equals(request.getResourceName()) && existingAssociation.getResourceNamespace().equals(request.getResourceNamespace()) && existingAssociation.isEquivalent(associationInRequest)) continue;
                throw new RestClientException(String.format("An association of type '%s' already exists for resource '%s", associationInRequest.getAssociationType(), request.getResourceId()), 422, 42212);
            }
            String subject2 = associationInRequest.getSubject();
            List<Association> existingAssociations = this.subjectToAssocCache.get(subject2);
            if (existingAssociations == null || existingAssociations.isEmpty()) continue;
            if (associationInRequest.getLifecycle() == LifecyclePolicy.STRONG) {
                throw new RestClientException(String.format("An association of type '%s', already exists for subject '%s", associationInRequest.getAssociationType(), subject2), 409, 40904);
            }
            if (existingAssociations.get(0).getLifecycle() != LifecyclePolicy.STRONG) continue;
            throw new RestClientException(String.format("A strong association of type '%s' already exists for subject '%s", associationInRequest.getAssociationType(), subject2), 409, 40905);
        }
        for (AssociationCreateOrUpdateInfo associationInRequest : request.getAssociations()) {
            subject = associationInRequest.getSubject();
            RegisterSchemaRequest schema = associationInRequest.getSchema();
            boolean normalize = associationInRequest.getNormalize();
            if (schema == null) continue;
            this.register(subject, this.parseSchema(new Schema(subject, schema)).get(), normalize);
        }
        for (AssociationCreateOrUpdateInfo associationInRequest : request.getAssociations()) {
            key = new ResourceAndAssocType(request.getResourceId(), request.getResourceType(), associationInRequest.getAssociationType());
            Association newAssociation = new Association(associationInRequest.getSubject(), UUID.randomUUID().toString(), request.getResourceName(), request.getResourceNamespace(), request.getResourceId(), request.getResourceType(), associationInRequest.getAssociationType(), associationInRequest.getLifecycle(), associationInRequest.getFrozen());
            this.resourceAndAssocTypeCache.put(key, newAssociation);
            this.subjectToAssocCache.computeIfAbsent(associationInRequest.getSubject(), k -> new ArrayList()).add(newAssociation);
            this.resourceIdToAssocCache.computeIfAbsent(request.getResourceId(), k -> new ArrayList()).add(newAssociation);
        }
    }

    private void validateAssociationCreateRequest(AssociationCreateOrUpdateRequest request) {
        request.validate();
        for (AssociationCreateOrUpdateInfo associationCreateInfo : request.getAssociations()) {
            if (associationCreateInfo.getSubject() == null || associationCreateInfo.getSubject().isEmpty()) {
                throw new IllegalArgumentException("subject in the association can't be null or empty");
            }
            if (associationCreateInfo.getAssociationType() == null || associationCreateInfo.getAssociationType().isEmpty()) {
                associationCreateInfo.setAssociationType(DEFAULT_ASSOCIATION_TYPE);
            }
            if (!this.validateResourceTypeAndAssociationType(request.getResourceType(), associationCreateInfo.getAssociationType())) {
                throw new IllegalArgumentException(String.format("resourceType {} and associationType {} don't match", request.getResourceType(), associationCreateInfo.getAssociationType()));
            }
            if (associationCreateInfo.getLifecycle() == null) {
                associationCreateInfo.setLifecycle(DEFAULT_LIFECYCLE_POLICY);
            }
            if (associationCreateInfo.getLifecycle() != LifecyclePolicy.WEAK || !associationCreateInfo.getFrozen().booleanValue()) continue;
            throw new IllegalArgumentException("the association can't be both weak and frozen");
        }
    }

    @Override
    public AssociationResponse createOrUpdateAssociation(AssociationCreateOrUpdateRequest request) throws IOException, RestClientException {
        try {
            this.validateAssociationCreateRequest(request);
        }
        catch (Exception e) {
            throw new RestClientException(String.format("The association specified an invalid value for property, %s", e.getMessage()), 422, 42212);
        }
        this.createAssociationsHelper(request);
        List<AssociationInfo> infos = request.getAssociations().stream().map(associationCreateOrUpdateInfo -> new AssociationInfo(associationCreateOrUpdateInfo.getSubject(), associationCreateOrUpdateInfo.getAssociationType(), associationCreateOrUpdateInfo.getLifecycle(), associationCreateOrUpdateInfo.getFrozen(), associationCreateOrUpdateInfo.getSchema() != null ? new Schema(associationCreateOrUpdateInfo.getSubject(), associationCreateOrUpdateInfo.getSchema()) : null)).collect(Collectors.toList());
        AssociationResponse response = new AssociationResponse(request.getResourceName(), request.getResourceNamespace(), request.getResourceId(), request.getResourceType(), infos);
        return response;
    }

    @Override
    public List<Association> getAssociationsBySubject(String subject, String resourceType, List<String> associationTypes, String lifecycle, int offset, int limit) throws IOException, RestClientException {
        List<Association> associations;
        if (subject == null || subject.isEmpty()) {
            throw new RestClientException("Association parameters are invalid", 422, 42212);
        }
        if (lifecycle != null) {
            try {
                LifecyclePolicy.valueOf(lifecycle);
            }
            catch (IllegalArgumentException e) {
                throw new RestClientException("Association parameters are invalid", 422, 42212);
            }
        }
        if ((associations = this.subjectToAssocCache.get(subject)) == null || associations.isEmpty()) {
            return new ArrayList<Association>();
        }
        int start = offset;
        List filtered = associations.stream().filter(association -> resourceType == null || association.getResourceType().equals(resourceType)).filter(association -> associationTypes == null || associationTypes.isEmpty() || associationTypes.contains(association.getAssociationType())).filter(association -> lifecycle == null || association.getLifecycle().toString().equals(lifecycle)).collect(Collectors.toList());
        if (start > filtered.size()) {
            start = filtered.size();
        }
        int end = start + limit;
        if (limit <= 0 || end > filtered.size()) {
            end = filtered.size();
        }
        return filtered.subList(start, end);
    }

    @Override
    public List<Association> getAssociationsByResourceId(String resourceId, String resourceType, List<String> associationTypes, String lifecycle, int offset, int limit) throws IOException, RestClientException {
        if (resourceId == null || resourceId.isEmpty()) {
            throw new RestClientException("Association parameters are invalid", 422, 42212);
        }
        List<Association> associations = this.resourceIdToAssocCache.get(resourceId);
        if (lifecycle != null) {
            try {
                LifecyclePolicy.valueOf(lifecycle);
            }
            catch (IllegalArgumentException e) {
                throw new RestClientException("Association parameters are invalid", 422, 42212);
            }
        }
        if (associations == null || associations.isEmpty()) {
            return new ArrayList<Association>();
        }
        int start = offset;
        List filtered = associations.stream().filter(association -> resourceType == null || association.getResourceType().equals(resourceType)).filter(association -> associationTypes == null || associationTypes.isEmpty() || associationTypes.contains(association.getAssociationType())).filter(association -> lifecycle == null || association.getLifecycle().toString().equals(lifecycle)).collect(Collectors.toList());
        if (start > filtered.size()) {
            start = filtered.size();
        }
        int end = start + limit;
        if (limit <= 0 || end > filtered.size()) {
            end = filtered.size();
        }
        return filtered.subList(start, end);
    }

    private void checkDeleteAssociation(Association association, boolean cascadeLifecycle) throws RestClientException {
        if (!cascadeLifecycle && association.getLifecycle() == LifecyclePolicy.STRONG && association.isFrozen()) {
            throw new RestClientException(String.format("The association of type '%s' is frozen for subject '%s", association.getAssociationType(), association.getSubject()), 409, 40908);
        }
    }

    private void deleteAssociation(Association association, boolean cascadeLifecycle) throws IOException, RestClientException {
        String subject = association.getSubject();
        String resourceId = association.getResourceId();
        if (cascadeLifecycle && association.getLifecycle() == LifecyclePolicy.STRONG) {
            this.deleteSubjectNoAssociationsCheck(null, subject, false);
            this.deleteSubjectNoAssociationsCheck(null, subject, true);
        }
        this.resourceIdToAssocCache.computeIfPresent(resourceId, (k, list) -> {
            list.remove(association);
            return list.isEmpty() ? null : list;
        });
        this.subjectToAssocCache.computeIfPresent(subject, (k, list) -> {
            list.remove(association);
            return list.isEmpty() ? null : list;
        });
        ResourceAndAssocType resourceAndAssocType = new ResourceAndAssocType(association.getResourceId(), association.getResourceType(), association.getAssociationType());
        this.resourceAndAssocTypeCache.remove(resourceAndAssocType);
    }

    @Override
    public synchronized void deleteAssociations(String resourceId, String resourceType, List<String> associationTypes, boolean cascadeLifecycle) throws IOException, RestClientException {
        List<Association> associationsToDelete = this.getAssociationsByResourceId(resourceId, resourceType, associationTypes, null, 0, -1);
        if (associationsToDelete == null || associationsToDelete.isEmpty()) {
            return;
        }
        for (Association associationToDelete : associationsToDelete) {
            this.checkDeleteAssociation(associationToDelete, cascadeLifecycle);
        }
        for (Association associationToDelete : associationsToDelete) {
            this.deleteAssociation(associationToDelete, cascadeLifecycle);
        }
    }

    private static class ResourceAndAssocType {
        String resourceId;
        String resourceType;
        String associationType;

        public ResourceAndAssocType(String resourceId, String resourceType, String associationType) {
            this.resourceId = resourceId;
            this.resourceType = resourceType;
            this.associationType = associationType;
        }

        public int hashCode() {
            return Objects.hash(this.resourceId, this.resourceType, this.associationType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceAndAssocType other = (ResourceAndAssocType)obj;
            return Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.associationType, other.associationType);
        }
    }
}

