/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class InstantiationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(InstantiationUtil.class);
    private static final VersionMismatchHandler versionMismatchHandler = new VersionMismatchHandler();

    public static <T> T instantiate(String className, Class<T> targetType, ClassLoader classLoader) throws FlinkException {
        Class<T> clazz;
        try {
            clazz = Class.forName(className, false, classLoader).asSubclass(targetType);
        }
        catch (ClassNotFoundException e) {
            throw new FlinkException(String.format("Could not instantiate class '%s' of type '%s'. Please make sure that this class is on your class path.", className, targetType.getName()), e);
        }
        return InstantiationUtil.instantiate(clazz);
    }

    public static <T> T instantiate(Class<T> clazz, Class<? super T> castTo) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (castTo != null && !castTo.isAssignableFrom(clazz)) {
            throw new RuntimeException("The class '" + clazz.getName() + "' is not a subclass of '" + castTo.getName() + "' as is required.");
        }
        return InstantiationUtil.instantiate(clazz);
    }

    public static <T> T instantiate(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException iex) {
            InstantiationUtil.checkForInstantiation(clazz);
            throw new RuntimeException("Could not instantiate type '" + clazz.getName() + "' due to an unspecified exception: " + iex.getMessage(), iex);
        }
        catch (Throwable t) {
            String message = t.getMessage();
            throw new RuntimeException("Could not instantiate type '" + clazz.getName() + "' Most likely the constructor (or a member variable initialization) threw an exception" + (message == null ? "." : ": " + message), t);
        }
    }

    public static boolean hasPublicNullaryConstructor(Class<?> clazz) {
        return Arrays.stream(clazz.getConstructors()).anyMatch(constructor -> constructor.getParameterCount() == 0);
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isProperClass(Class<?> clazz) {
        int mods = clazz.getModifiers();
        return !Modifier.isAbstract(mods) && !Modifier.isInterface(mods) && !Modifier.isNative(mods);
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return clazz.getEnclosingClass() != null && (clazz.getDeclaringClass() == null || !Modifier.isStatic(clazz.getModifiers()));
    }

    public static void checkForInstantiation(Class<?> clazz) {
        String errorMessage = InstantiationUtil.checkForInstantiationError(clazz);
        if (errorMessage != null) {
            throw new RuntimeException("The class '" + clazz.getName() + "' is not instantiable: " + errorMessage);
        }
    }

    public static String checkForInstantiationError(Class<?> clazz) {
        if (!InstantiationUtil.isPublic(clazz)) {
            return "The class is not public.";
        }
        if (clazz.isArray()) {
            return "The class is an array. An array cannot be simply instantiated, as with a parameterless constructor.";
        }
        if (!InstantiationUtil.isProperClass(clazz)) {
            return "The class is not a proper class. It is either abstract, an interface, or a primitive type.";
        }
        if (InstantiationUtil.isNonStaticInnerClass(clazz)) {
            return "The class is an inner class, but not statically accessible.";
        }
        if (!InstantiationUtil.hasPublicNullaryConstructor(clazz)) {
            return "The class has no (implicit) public nullary constructor, i.e. a constructor without arguments.";
        }
        return null;
    }

    @Nullable
    public static <T> T readObjectFromConfig(Configuration config, String key, ClassLoader cl) throws IOException, ClassNotFoundException {
        byte[] bytes = config.getBytes(key, null);
        if (bytes == null) {
            return null;
        }
        return InstantiationUtil.deserializeObject(bytes, cl);
    }

    public static void writeObjectToConfig(Object o, Configuration config, String key) throws IOException {
        byte[] bytes = InstantiationUtil.serializeObject(o);
        config.setBytes(key, bytes);
    }

    public static <T> byte[] serializeToByteArray(TypeSerializer<T> serializer, T record) throws IOException {
        if (record == null) {
            throw new NullPointerException("Record to serialize to byte array must not be null.");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputViewStreamWrapper outputViewWrapper = new DataOutputViewStreamWrapper(bos);
        serializer.serialize(record, outputViewWrapper);
        return bos.toByteArray();
    }

    public static <T> T deserializeFromByteArray(TypeSerializer<T> serializer, byte[] buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException("Byte array to deserialize from must not be null.");
        }
        DataInputViewStreamWrapper inputViewWrapper = new DataInputViewStreamWrapper(new ByteArrayInputStream(buf));
        return serializer.deserialize(inputViewWrapper);
    }

    public static <T> T deserializeFromByteArray(TypeSerializer<T> serializer, T reuse, byte[] buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException("Byte array to deserialize from must not be null.");
        }
        DataInputViewStreamWrapper inputViewWrapper = new DataInputViewStreamWrapper(new ByteArrayInputStream(buf));
        return serializer.deserialize(reuse, inputViewWrapper);
    }

    public static <T> T deserializeObject(byte[] bytes, ClassLoader cl) throws IOException, ClassNotFoundException {
        return InstantiationUtil.deserializeObject(new ByteArrayInputStream(bytes), cl);
    }

    public static <T> T deserializeObject(InputStream in, ClassLoader cl) throws IOException, ClassNotFoundException {
        return InstantiationUtil.deserializeObject(in, cl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deserializeObject(InputStream in, ClassLoader cl, boolean tolerateKnownVersionMismatch) throws IOException, ClassNotFoundException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoaderObjectInputStream oois = tolerateKnownVersionMismatch ? new FailureTolerantObjectInputStream(in, cl) : new ClassLoaderObjectInputStream(in, cl);
            Thread.currentThread().setContextClassLoader(cl);
            Object object = oois.readObject();
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public static <T> T decompressAndDeserializeObject(byte[] bytes, ClassLoader cl) throws IOException, ClassNotFoundException {
        return InstantiationUtil.deserializeObject(new InflaterInputStream(new ByteArrayInputStream(bytes)), cl);
    }

    public static byte[] serializeObject(Object o) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(o);
                oos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public static void serializeObject(OutputStream out, Object o) throws IOException {
        ObjectOutputStream oos = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
        oos.writeObject(o);
    }

    /*
     * Exception decompiling
     */
    public static byte[] serializeObjectAndCompress(Object o) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isSerializable(Object o) {
        try {
            InstantiationUtil.serializeObject(o);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static <T extends Serializable> T clone(T obj) throws IOException, ClassNotFoundException {
        if (obj == null) {
            return null;
        }
        return InstantiationUtil.clone(obj, obj.getClass().getClassLoader());
    }

    public static <T extends Serializable> T clone(T obj, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        if (obj == null) {
            return null;
        }
        byte[] serializedObject = InstantiationUtil.serializeObject(obj);
        return (T)((Serializable)InstantiationUtil.deserializeObject(serializedObject, classLoader));
    }

    public static <T extends Serializable> T cloneUnchecked(T obj) {
        try {
            return InstantiationUtil.clone(obj, obj.getClass().getClassLoader());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(String.format("Unable to clone instance of %s.", obj.getClass().getName()), e);
        }
    }

    public static <T extends IOReadableWritable> T createCopyWritable(T original) throws IOException {
        if (original == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper(baos);){
            original.write(out);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (DataInputViewStreamWrapper in = new DataInputViewStreamWrapper(bais);){
            IOReadableWritable copy = (IOReadableWritable)InstantiationUtil.instantiate(original.getClass());
            copy.read(in);
            IOReadableWritable iOReadableWritable = copy;
            return (T)iOReadableWritable;
        }
    }

    public static <T> Class<T> resolveClassByName(DataInputView in, ClassLoader cl) throws IOException {
        return InstantiationUtil.resolveClassByName(in, cl, Object.class);
    }

    public static <T> Class<T> resolveClassByName(DataInputView in, ClassLoader cl, Class<? super T> supertype) throws IOException {
        Class<?> rawClazz;
        String className = in.readUTF();
        try {
            rawClazz = Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            String error = "Could not find class '" + className + "' in classpath.";
            if (className.contains("SerializerConfig")) {
                error = error + " TypeSerializerConfigSnapshot and it's subclasses are not supported since Flink 1.17. If you are using built-in serializers, please first migrate to Flink 1.16. If you are using custom serializers, please migrate them to TypeSerializerSnapshot using Flink 1.16.";
            }
            throw new IOException(error, e);
        }
        if (!supertype.isAssignableFrom(rawClazz)) {
            throw new IOException("The class " + className + " is not a subclass of " + supertype.getName());
        }
        Class<?> clazz = rawClazz;
        return clazz;
    }

    private InstantiationUtil() {
        throw new RuntimeException();
    }

    static {
        versionMismatchHandler.addVersionsMatch("org.apache.flink.table.runtime.typeutils.MapDataSerializer", 4073842523628732956L, Collections.singletonList(2533002123505507000L));
    }

    public static class FailureTolerantObjectInputStream
    extends ClassLoaderObjectInputStream {
        public FailureTolerantObjectInputStream(InputStream in, ClassLoader cl) throws IOException {
            super(in, cl);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass localClassDescriptor;
            ObjectStreamClass streamClassDescriptor = super.readClassDescriptor();
            Class<?> localClass = this.resolveClass(streamClassDescriptor);
            String name = localClass.getName();
            if (versionMismatchHandler.haveRulesForClass(name) && (localClassDescriptor = ObjectStreamClass.lookup(localClass)) != null && localClassDescriptor.getSerialVersionUID() != streamClassDescriptor.getSerialVersionUID() && versionMismatchHandler.shouldTolerateSerialVersionMismatch(name, localClassDescriptor.getSerialVersionUID(), streamClassDescriptor.getSerialVersionUID())) {
                LOG.warn("Ignoring serialVersionUID mismatch for class {}; was {}, now {}.", new Object[]{streamClassDescriptor.getName(), streamClassDescriptor.getSerialVersionUID(), localClassDescriptor.getSerialVersionUID()});
                streamClassDescriptor = localClassDescriptor;
            }
            return streamClassDescriptor;
        }
    }

    private static final class VersionMismatchHandler {
        private final Map<String, Map<Long, List<Long>>> supportedSerialVersionUidsPerClass = new HashMap<String, Map<Long, List<Long>>>();

        private VersionMismatchHandler() {
        }

        void addVersionsMatch(String className, long localVersionUID, List<Long> streamVersionUIDs) {
            this.supportedSerialVersionUidsPerClass.computeIfAbsent(className, k -> new HashMap()).put(localVersionUID, streamVersionUIDs);
        }

        boolean shouldTolerateSerialVersionMismatch(String className, long localVersionUID, long streamVersionUID) {
            return this.supportedSerialVersionUidsPerClass.getOrDefault(className, Collections.emptyMap()).getOrDefault(localVersionUID, Collections.emptyList()).contains(streamVersionUID);
        }

        boolean haveRulesForClass(String className) {
            return this.supportedSerialVersionUidsPerClass.containsKey(className);
        }
    }

    public static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        protected final ClassLoader classLoader;
        private static final HashMap<String, Class<?>> primitiveClasses = CollectionUtil.newHashMapWithExpectedSize(9);

        public ClassLoaderObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this.classLoader != null) {
                String name = desc.getName();
                try {
                    return Class.forName(name, false, this.classLoader);
                }
                catch (ClassNotFoundException ex) {
                    Class<?> cl = primitiveClasses.get(name);
                    if (cl != null) {
                        return cl;
                    }
                    throw ex;
                }
            }
            return super.resolveClass(desc);
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            if (this.classLoader != null) {
                ClassLoader nonPublicLoader = null;
                boolean hasNonPublicInterface = false;
                Class[] classObjs = new Class[interfaces.length];
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> cl = Class.forName(interfaces[i], false, this.classLoader);
                    if ((cl.getModifiers() & 1) == 0) {
                        if (hasNonPublicInterface) {
                            if (nonPublicLoader != cl.getClassLoader()) {
                                throw new IllegalAccessError("conflicting non-public interface class loaders");
                            }
                        } else {
                            nonPublicLoader = cl.getClassLoader();
                            hasNonPublicInterface = true;
                        }
                    }
                    classObjs[i] = cl;
                }
                try {
                    return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : this.classLoader, classObjs);
                }
                catch (IllegalArgumentException e) {
                    throw new ClassNotFoundException(null, e);
                }
            }
            return super.resolveProxyClass(interfaces);
        }

        static {
            primitiveClasses.put("boolean", Boolean.TYPE);
            primitiveClasses.put("byte", Byte.TYPE);
            primitiveClasses.put("char", Character.TYPE);
            primitiveClasses.put("short", Short.TYPE);
            primitiveClasses.put("int", Integer.TYPE);
            primitiveClasses.put("long", Long.TYPE);
            primitiveClasses.put("float", Float.TYPE);
            primitiveClasses.put("double", Double.TYPE);
            primitiveClasses.put("void", Void.TYPE);
        }
    }
}

