/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.FlinkExpectedException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.function.RunnableWithException;
import org.slf4j.Logger;

@Internal
public final class ExceptionUtils {
    public static final String STRINGIFIED_NULL_EXCEPTION = "(null)";

    public static String stringifyException(Throwable e) {
        if (e == null) {
            return STRINGIFIED_NULL_EXCEPTION;
        }
        try {
            StringWriter stm = new StringWriter();
            PrintWriter wrt = new PrintWriter(stm);
            e.printStackTrace(wrt);
            wrt.close();
            return stm.toString();
        }
        catch (Throwable t) {
            return e.getClass().getName() + " (error while printing stack trace)";
        }
    }

    public static boolean isJvmFatalError(Throwable t) {
        return t instanceof InternalError || t instanceof UnknownError || t instanceof ThreadDeath;
    }

    public static boolean isJvmFatalOrOutOfMemoryError(Throwable t) {
        return ExceptionUtils.isJvmFatalError(t) || t instanceof OutOfMemoryError;
    }

    public static void tryEnrichOutOfMemoryError(@Nullable Throwable root, @Nullable String jvmMetaspaceOomNewErrorMessage, @Nullable String jvmDirectOomNewErrorMessage, @Nullable String jvmHeapSpaceOomNewErrorMessage) {
        ExceptionUtils.updateDetailMessage(root, t -> {
            if (ExceptionUtils.isMetaspaceOutOfMemoryError(t)) {
                return jvmMetaspaceOomNewErrorMessage;
            }
            if (ExceptionUtils.isDirectOutOfMemoryError(t)) {
                return jvmDirectOomNewErrorMessage;
            }
            if (ExceptionUtils.isHeapSpaceOutOfMemoryError(t)) {
                return jvmHeapSpaceOomNewErrorMessage;
            }
            return null;
        });
    }

    public static void updateDetailMessage(@Nullable Throwable root, @Nullable Function<Throwable, String> throwableToMessage) {
        if (throwableToMessage == null) {
            return;
        }
        for (Throwable it = root; it != null; it = it.getCause()) {
            String newMessage = throwableToMessage.apply(it);
            if (newMessage == null) continue;
            ExceptionUtils.updateDetailMessageOfThrowable(it, newMessage);
        }
    }

    private static void updateDetailMessageOfThrowable(Throwable throwable, String newDetailMessage) {
        Field field;
        try {
            field = Throwable.class.getDeclaredField("detailMessage");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("The JDK Throwable contains a detailMessage member. The Throwable class provided on the classpath does not which is why this exception appears.", e);
        }
        field.setAccessible(true);
        try {
            field.set(throwable, newDetailMessage);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("The JDK Throwable contains a private detailMessage member that should be accessible through reflection. This is not the case for the Throwable class provided on the classpath.", e);
        }
    }

    public static boolean isMetaspaceOutOfMemoryError(@Nullable Throwable t) {
        return ExceptionUtils.isOutOfMemoryErrorWithMessageContaining(t, "Metaspace");
    }

    public static boolean isDirectOutOfMemoryError(@Nullable Throwable t) {
        return ExceptionUtils.isOutOfMemoryErrorWithMessageContaining(t, "Direct buffer memory");
    }

    public static boolean isHeapSpaceOutOfMemoryError(@Nullable Throwable t) {
        return ExceptionUtils.isOutOfMemoryErrorWithMessageContaining(t, "Java heap space");
    }

    private static boolean isOutOfMemoryErrorWithMessageContaining(@Nullable Throwable t, String infix) {
        return ExceptionUtils.isOutOfMemoryError(t) && t.getMessage() != null && t.getMessage().toLowerCase(Locale.ROOT).contains(infix.toLowerCase(Locale.ROOT));
    }

    private static boolean isOutOfMemoryError(@Nullable Throwable t) {
        return t != null && t.getClass() == OutOfMemoryError.class;
    }

    public static void rethrowIfFatalError(Throwable t) {
        if (ExceptionUtils.isJvmFatalError(t)) {
            throw (Error)t;
        }
    }

    public static void rethrowIfFatalErrorOrOOM(Throwable t) {
        if (ExceptionUtils.isJvmFatalError(t) || t instanceof OutOfMemoryError) {
            throw (Error)t;
        }
    }

    public static <T extends Throwable> T firstOrSuppressed(T newException, @Nullable T previous) {
        Preconditions.checkNotNull(newException, "newException");
        if (previous == null || previous == newException) {
            return newException;
        }
        previous.addSuppressed(newException);
        return previous;
    }

    public static void rethrow(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public static void rethrow(Throwable t, String parentMessage) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(parentMessage, t);
    }

    public static void rethrowException(Throwable t, String parentMessage) throws Exception {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        throw new Exception(parentMessage, t);
    }

    public static void rethrowException(Throwable t) throws Exception {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        throw new Exception(t.getMessage(), t);
    }

    public static void tryRethrowException(@Nullable Exception e) throws Exception {
        if (e != null) {
            throw e;
        }
    }

    public static void tryRethrowIOException(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    public static void rethrowIOException(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IOException(t.getMessage(), t);
    }

    public static <T extends Throwable> Optional<T> findSerializedThrowable(Throwable throwable, Class<T> searchType, ClassLoader classLoader) {
        if (throwable == null || searchType == null) {
            return Optional.empty();
        }
        Throwable t = throwable;
        while (t != null) {
            if (searchType.isAssignableFrom(t.getClass())) {
                return Optional.of((Throwable)searchType.cast(t));
            }
            if (t.getClass().isAssignableFrom(SerializedThrowable.class)) {
                Throwable next = ((SerializedThrowable)t).deserializeError(classLoader);
                t = next == t ? null : next;
                continue;
            }
            t = t.getCause();
        }
        return Optional.empty();
    }

    public static <T extends Throwable> Optional<T> findThrowable(Throwable throwable, Class<T> searchType) {
        if (throwable == null || searchType == null) {
            return Optional.empty();
        }
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!searchType.isAssignableFrom(t.getClass())) continue;
            return Optional.of((Throwable)searchType.cast(t));
        }
        return Optional.empty();
    }

    public static <T extends Throwable> void assertThrowable(Throwable throwable, Class<T> searchType) throws T {
        if (!ExceptionUtils.findThrowable(throwable, searchType).isPresent()) {
            throw throwable;
        }
    }

    public static <T extends Throwable> Optional<T> findThrowableSerializedAware(Throwable throwable, Class<T> searchType, ClassLoader classLoader) {
        if (throwable == null || searchType == null) {
            return Optional.empty();
        }
        Throwable t = throwable;
        while (t != null) {
            if (searchType.isAssignableFrom(t.getClass())) {
                return Optional.of((Throwable)searchType.cast(t));
            }
            if (t instanceof SerializedThrowable) {
                t = ((SerializedThrowable)t).deserializeError(classLoader);
                continue;
            }
            t = t.getCause();
        }
        return Optional.empty();
    }

    public static Optional<Throwable> findThrowable(Throwable throwable, Predicate<Throwable> predicate) {
        if (throwable == null || predicate == null) {
            return Optional.empty();
        }
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!predicate.test(t)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static <T extends Throwable> void assertThrowable(T throwable, Predicate<Throwable> predicate) throws T {
        if (!ExceptionUtils.findThrowable(throwable, predicate).isPresent()) {
            throw throwable;
        }
    }

    public static Optional<Throwable> findThrowableWithMessage(Throwable throwable, String searchMessage) {
        if (throwable == null || searchMessage == null) {
            return Optional.empty();
        }
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (t.getMessage() == null || !t.getMessage().contains(searchMessage)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static <T extends Throwable> void assertThrowableWithMessage(Throwable throwable, String searchMessage) throws T {
        if (!ExceptionUtils.findThrowableWithMessage(throwable, searchMessage).isPresent()) {
            throw throwable;
        }
    }

    public static Throwable stripExecutionException(Throwable throwable) {
        return ExceptionUtils.stripException(throwable, ExecutionException.class);
    }

    public static Throwable stripCompletionException(Throwable throwable) {
        return ExceptionUtils.stripException(throwable, CompletionException.class);
    }

    public static Throwable stripException(Throwable throwableToStrip, Class<? extends Throwable> typeToStrip) {
        while (typeToStrip.isAssignableFrom(throwableToStrip.getClass()) && throwableToStrip.getCause() != null) {
            throwableToStrip = throwableToStrip.getCause();
        }
        return throwableToStrip;
    }

    public static void tryDeserializeAndThrow(Throwable throwable, ClassLoader classLoader) throws Throwable {
        Throwable current = throwable;
        while (!(current instanceof SerializedThrowable) && current.getCause() != null) {
            current = current.getCause();
        }
        if (current instanceof SerializedThrowable) {
            throw ((SerializedThrowable)current).deserializeError(classLoader);
        }
        throw throwable;
    }

    public static void checkInterrupted(Throwable e) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static Throwable returnExceptionIfUnexpected(Throwable e) {
        return e instanceof FlinkExpectedException ? null : e;
    }

    public static void logExceptionIfExcepted(Throwable e, Logger log) {
        if (e instanceof FlinkExpectedException) {
            log.debug("Expected exception.", e);
        }
    }

    public static void suppressExceptions(RunnableWithException action) {
        block3: {
            try {
                action.run();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                if (!ExceptionUtils.isJvmFatalError(t)) break block3;
                ExceptionUtils.rethrow(t);
            }
        }
    }

    private ExceptionUtils() {
    }
}

