/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;

@PublicEvolving
public class DoubleCounter
implements SimpleAccumulator<Double> {
    private static final long serialVersionUID = 1L;
    private double localValue = 0.0;

    public DoubleCounter() {
    }

    public DoubleCounter(double value) {
        this.localValue = value;
    }

    @Override
    public void add(Double value) {
        this.localValue += value.doubleValue();
    }

    @Override
    public Double getLocalValue() {
        return this.localValue;
    }

    @Override
    public void merge(Accumulator<Double, Double> other) {
        this.localValue += other.getLocalValue().doubleValue();
    }

    @Override
    public void resetLocal() {
        this.localValue = 0.0;
    }

    public DoubleCounter clone() {
        DoubleCounter result = new DoubleCounter();
        result.localValue = this.localValue;
        return result;
    }

    @Override
    public void add(double value) {
        this.localValue += value;
    }

    public double getLocalValuePrimitive() {
        return this.localValue;
    }

    public String toString() {
        return "DoubleCounter " + this.localValue;
    }
}

