/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client;

import io.cloudsoft.winrm4j.client.WinRmClient;
import io.cloudsoft.winrm4j.client.WinRmClientContext;
import io.cloudsoft.winrm4j.client.wsman.Locale;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;

public class WinRmClientBuilder {
    private static final java.util.Locale DEFAULT_LOCALE = java.util.Locale.US;
    private static final Long DEFAULT_OPERATION_TIMEOUT = 60000L;
    private static final int DEFAULT_RETRIES_FOR_CONNECTION_FAILURES = 1;
    protected WinRmClientContext context;
    protected final URL endpoint;
    protected String authenticationScheme;
    protected String domain;
    protected String username;
    protected String password;
    protected String workingDirectory;
    protected Locale locale;
    protected long operationTimeout;
    protected Long receiveTimeout;
    protected int retriesForConnectionFailures;
    protected Map<String, String> environment;
    protected boolean disableCertificateChecks;
    protected HostnameVerifier hostnameVerifier;

    WinRmClientBuilder(String endpoint) {
        this(WinRmClientBuilder.toUrlUnchecked(WinRmClient.checkNotNull(endpoint, "endpoint")));
    }

    WinRmClientBuilder(URL endpoint) {
        this.endpoint = WinRmClient.checkNotNull(endpoint, "endpoint");
        this.authenticationScheme("NTLM");
        this.locale(DEFAULT_LOCALE);
        this.operationTimeout(DEFAULT_OPERATION_TIMEOUT);
        this.retriesForConnectionFailures(1);
    }

    public WinRmClientBuilder authenticationScheme(String authenticationScheme) {
        this.authenticationScheme = WinRmClient.checkNotNull(authenticationScheme, "authenticationScheme");
        return this;
    }

    public WinRmClientBuilder credentials(String username, String password) {
        return this.credentials(null, username, password);
    }

    public WinRmClientBuilder credentials(String domain, String username, String password) {
        this.domain = domain;
        this.username = WinRmClient.checkNotNull(username, "username");
        this.password = WinRmClient.checkNotNull(password, "password");
        return this;
    }

    public WinRmClientBuilder locale(java.util.Locale locale) {
        Locale l = new Locale();
        l.setLang(WinRmClient.checkNotNull(locale, "locale").toLanguageTag());
        this.locale = l;
        return this;
    }

    public WinRmClientBuilder operationTimeout(long operationTimeout) {
        this.operationTimeout = WinRmClient.checkNotNull(operationTimeout, "operationTimeout");
        return this;
    }

    public WinRmClientBuilder retriesForConnectionFailures(int retriesConnectionFailures) {
        if (retriesConnectionFailures < 1) {
            throw new IllegalArgumentException("retriesConnectionFailure should be one or more");
        }
        this.retriesForConnectionFailures = retriesConnectionFailures;
        return this;
    }

    public WinRmClientBuilder disableCertificateChecks(boolean disableCertificateChecks) {
        this.disableCertificateChecks = disableCertificateChecks;
        return this;
    }

    public WinRmClientBuilder workingDirectory(String workingDirectory) {
        this.workingDirectory = WinRmClient.checkNotNull(workingDirectory, "workingDirectory");
        return this;
    }

    public WinRmClientBuilder environment(Map<String, String> environment) {
        this.environment = WinRmClient.checkNotNull(environment, "environment");
        return this;
    }

    public WinRmClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public WinRmClientBuilder context(WinRmClientContext context) {
        this.context = context;
        return this;
    }

    public WinRmClient build() {
        return new WinRmClient(this);
    }

    protected static URL toUrlUnchecked(String endpoint) {
        try {
            return new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

