/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client;

import io.cloudsoft.winrm4j.client.RetryingProxyHandler;
import io.cloudsoft.winrm4j.client.ShellCommand;
import io.cloudsoft.winrm4j.client.StripShellResponseHandler;
import io.cloudsoft.winrm4j.client.WinRm;
import io.cloudsoft.winrm4j.client.WinRmClientBuilder;
import io.cloudsoft.winrm4j.client.WinRmClientContext;
import io.cloudsoft.winrm4j.client.WinRmFactory;
import io.cloudsoft.winrm4j.client.ntlm.SpNegoNTLMSchemeFactory;
import io.cloudsoft.winrm4j.client.shell.EnvironmentVariable;
import io.cloudsoft.winrm4j.client.shell.EnvironmentVariableList;
import io.cloudsoft.winrm4j.client.shell.Shell;
import io.cloudsoft.winrm4j.client.transfer.ResourceCreated;
import io.cloudsoft.winrm4j.client.wsman.Locale;
import io.cloudsoft.winrm4j.client.wsman.OptionSetType;
import io.cloudsoft.winrm4j.client.wsman.OptionType;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.policy.MetadataConstants;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.PrimitiveAssertion;
import org.w3c.dom.Element;

public class WinRmClient {
    static final int MAX_ENVELOPER_SIZE = 153600;
    static final String RESOURCE_URI = "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/cmd";
    private final String workingDirectory;
    private final Locale locale;
    private final Map<String, String> environment;
    private String operationTimeout;
    private final WinRmClientContext context;
    private final boolean cleanupContext;
    private final WinRm winrm;
    private RetryingProxyHandler retryingHandler;
    private ShellCommand shellCommand;

    public static WinRmClientBuilder builder(URL endpoint) {
        return new WinRmClientBuilder(endpoint);
    }

    public static WinRmClientBuilder builder(String endpoint) {
        return new WinRmClientBuilder(endpoint);
    }

    @Deprecated
    public static Builder builder(URL endpoint, String authenticationScheme) {
        return new Builder(endpoint, authenticationScheme);
    }

    @Deprecated
    public static Builder builder(String endpoint, String authenticationScheme) {
        return new Builder(endpoint, authenticationScheme);
    }

    WinRmClient(WinRmClientBuilder builder) {
        this.workingDirectory = builder.workingDirectory;
        this.locale = builder.locale;
        this.operationTimeout = WinRmClient.toDuration(builder.operationTimeout);
        this.environment = builder.environment;
        if (builder.context != null) {
            this.context = builder.context;
            this.cleanupContext = false;
        } else {
            this.context = WinRmClientContext.newInstance();
            this.cleanupContext = true;
        }
        WinRm service = this.getService(builder);
        this.retryingHandler = new RetryingProxyHandler(service, builder.retriesForConnectionFailures);
        this.winrm = (WinRm)Proxy.newProxyInstance(WinRm.class.getClassLoader(), new Class[]{WinRm.class, BindingProvider.class}, (InvocationHandler)this.retryingHandler);
    }

    @Deprecated
    public void setOperationTimeout(long timeout) {
        this.operationTimeout = WinRmClient.toDuration(timeout);
    }

    private WinRm getService(WinRmClientBuilder builder) {
        WinRm service = WinRmFactory.newInstance(this.context.getBus());
        WinRmClient.initializeClientAndService(service, builder);
        return service;
    }

    @Deprecated
    public int command(String cmd, Writer out, Writer err) {
        return this.initInstanceShell().execute(cmd, out, err);
    }

    @Deprecated
    public int getNumberOfReceiveCalls() {
        if (this.shellCommand == null) {
            return 0;
        }
        return this.shellCommand.getNumberOfReceiveCalls();
    }

    private static void initializeClientAndService(WinRm winrm, WinRmClientBuilder builder) {
        String endpoint = builder.endpoint.toExternalForm();
        String authenticationScheme = builder.authenticationScheme;
        String username = builder.username;
        String password = builder.password;
        String domain = builder.domain;
        boolean disableCertificateChecks = builder.disableCertificateChecks;
        HostnameVerifier hostnameVerifier = builder.hostnameVerifier;
        long receiveTimeout = builder.receiveTimeout != null ? builder.receiveTimeout : WinRmClient.operationToReceiveTimeout(builder.operationTimeout);
        Client client = ClientProxy.getClient((Object)winrm);
        ServiceInfo si = client.getEndpoint().getEndpointInfo().getService();
        si.setProperty("soap.force.doclit.bare", (Object)true);
        BindingProvider bp = (BindingProvider)winrm;
        List<Handler> handlerChain = Arrays.asList(new StripShellResponseHandler());
        bp.getBinding().setHandlerChain(handlerChain);
        Policy policy = new Policy();
        policy.addAssertion((Assertion)new PrimitiveAssertion(MetadataConstants.USING_ADDRESSING_2004_QNAME));
        bp.getRequestContext().put("org.apache.cxf.ws.policy.override", policy);
        bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint);
        switch (authenticationScheme) {
            case "Basic": {
                bp.getRequestContext().put("javax.xml.ws.security.auth.username", username);
                bp.getRequestContext().put("javax.xml.ws.security.auth.password", password);
                break;
            }
            case "NTLM": 
            case "Kerberos": {
                TLSClientParameters tlsClientParameters;
                NTCredentials creds = new NTCredentials(username, password, null, domain);
                Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("Negotiate", (Object)(authenticationScheme.equals("NTLM") ? new SpNegoNTLMSchemeFactory() : new SPNegoSchemeFactory())).register("Kerberos", (Object)new KerberosSchemeFactory()).build();
                bp.getRequestContext().put(Credentials.class.getName(), creds);
                bp.getRequestContext().put("http.autoredirect", true);
                bp.getRequestContext().put(AuthSchemeProvider.class.getName(), authSchemeRegistry);
                AsyncHTTPConduit httpClient = (AsyncHTTPConduit)client.getConduit();
                if (disableCertificateChecks) {
                    tlsClientParameters = new TLSClientParameters();
                    tlsClientParameters.setDisableCNCheck(true);
                    tlsClientParameters.setTrustManagers(new TrustManager[]{new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }});
                    httpClient.setTlsClientParameters(tlsClientParameters);
                }
                if (hostnameVerifier != null) {
                    tlsClientParameters = new TLSClientParameters();
                    tlsClientParameters.setHostnameVerifier(hostnameVerifier);
                    httpClient.setTlsClientParameters(tlsClientParameters);
                }
                HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
                httpClientPolicy.setAllowChunking(false);
                httpClientPolicy.setReceiveTimeout(receiveTimeout);
                httpClient.setClient(httpClientPolicy);
                httpClient.getClient().setAutoRedirect(true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("No such authentication scheme " + authenticationScheme);
            }
        }
    }

    public ShellCommand createShell() {
        Shell shell = new Shell();
        shell.getInputStreams().add("stdin");
        shell.getOutputStreams().add("stdout");
        shell.getOutputStreams().add("stderr");
        if (this.workingDirectory != null) {
            shell.setWorkingDirectory(this.workingDirectory);
        }
        if (this.environment != null && !this.environment.isEmpty()) {
            EnvironmentVariableList env = new EnvironmentVariableList();
            List<EnvironmentVariable> vars = env.getVariable();
            for (Map.Entry<String, String> entry : this.environment.entrySet()) {
                EnvironmentVariable var = new EnvironmentVariable();
                var.setName(entry.getKey());
                var.setValue(entry.getValue());
                vars.add(var);
            }
            shell.setEnvironment(env);
        }
        OptionSetType optSetCreate = new OptionSetType();
        OptionType optNoProfile = new OptionType();
        optNoProfile.setName("WINRS_NOPROFILE");
        optNoProfile.setValue("FALSE");
        optSetCreate.getOption().add(optNoProfile);
        OptionType optCodepage = new OptionType();
        optCodepage.setName("WINRS_CODEPAGE");
        optCodepage.setValue("437");
        optSetCreate.getOption().add(optCodepage);
        ResourceCreated resourceCreated = this.winrm.create(shell, RESOURCE_URI, 153600, this.operationTimeout, this.locale, optSetCreate);
        String shellId = WinRmClient.getShellId(resourceCreated);
        return new ShellCommand(this.winrm, shellId, this.operationTimeout, this.locale);
    }

    private static String getShellId(ResourceCreated resourceCreated) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        for (Element el : resourceCreated.getAny()) {
            String shellId;
            try {
                shellId = xpath.evaluate("//*[local-name()='Selector' and @Name='ShellId']", el);
            }
            catch (XPathExpressionException e) {
                throw new IllegalStateException(e);
            }
            if (shellId == null || shellId.isEmpty()) continue;
            return shellId;
        }
        throw new IllegalStateException("Shell ID not fount in " + resourceCreated);
    }

    @Deprecated
    public void disconnect() {
        boolean isBusRunning;
        if (this.context == null) {
            return;
        }
        boolean bl = isBusRunning = this.context.getBus().getState() != Bus.BusState.SHUTDOWN;
        if (!isBusRunning) {
            return;
        }
        try {
            ShellCommand oldShellCmd = this.cleanupInstanceShell();
            if (oldShellCmd != null) {
                oldShellCmd.close();
            }
        }
        finally {
            if (this.cleanupContext) {
                this.context.getBus().shutdown(true);
            }
        }
    }

    private synchronized ShellCommand initInstanceShell() {
        if (this.shellCommand == null) {
            this.shellCommand = this.createShell();
        }
        return this.shellCommand;
    }

    private synchronized ShellCommand cleanupInstanceShell() {
        ShellCommand cmd = this.shellCommand;
        this.shellCommand = null;
        return cmd;
    }

    private static long operationToReceiveTimeout(long operationTimeout) {
        return operationTimeout + 60000L;
    }

    private static String toDuration(long operationTimeout) {
        BigDecimal bdMs = BigDecimal.valueOf(operationTimeout);
        BigDecimal bdSec = bdMs.divide(BigDecimal.valueOf(1000L));
        DecimalFormat df = new DecimalFormat("PT#.###S", new DecimalFormatSymbols(java.util.Locale.ROOT));
        return df.format(bdSec);
    }

    public static <T> T checkNotNull(T check, String msg) {
        if (check == null) {
            throw new NullPointerException(msg);
        }
        return check;
    }

    @Deprecated
    public static class Builder
    extends WinRmClientBuilder {
        @Deprecated
        public static final Long DEFAULT_OPERATION_TIMEOUT = 60000L;

        @Deprecated
        public Builder(URL endpoint, String authenticationScheme) {
            this(endpoint);
            this.authenticationScheme(authenticationScheme);
        }

        public Builder(String endpoint, String authenticationScheme) {
            this(WinRmClientBuilder.toUrlUnchecked(WinRmClient.checkNotNull(endpoint, "endpoint")), WinRmClient.checkNotNull(authenticationScheme, "authenticationScheme"));
        }

        Builder(String endpoint) {
            super(endpoint);
        }

        Builder(URL endpoint) {
            super(endpoint);
        }
    }
}

