/*
 * Decompiled with CFR 0.152.
 */
package io.cloudsoft.winrm4j.client;

import io.cloudsoft.winrm4j.client.WinRm;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetryingProxyHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RetryingProxyHandler.class);
    private final WinRm winrm;
    private int retriesForConnectionFailures;

    public RetryingProxyHandler(WinRm winrm, int retriesForConnectionFailures) {
        this.winrm = winrm;
        this.retriesForConnectionFailures = retriesForConnectionFailures;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("command")) {
            return method.invoke((Object)this.winrm, args);
        }
        return this.invokeWithRetry(method, args);
    }

    public Object invokeWithRetry(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        ArrayList<WebServiceException> exceptions = new ArrayList<WebServiceException>();
        for (int i = 0; i < this.retriesForConnectionFailures + 1; ++i) {
            try {
                return method.invoke((Object)this.winrm, args);
            }
            catch (InvocationTargetException targetException) {
                WebServiceException wsException;
                Throwable e = targetException.getTargetException();
                if (e instanceof SOAPFaultException) {
                    throw (SOAPFaultException)e;
                }
                if (e instanceof WebServiceException) {
                    wsException = (WebServiceException)e;
                    if (!(wsException.getCause() instanceof IOException)) {
                        throw new RuntimeException("Exception occurred while making winrm call", (Throwable)wsException);
                    }
                    LOG.debug("Ignoring exception and retrying (attempt " + (i + 1) + " of " + (this.retriesForConnectionFailures + 1) + ") {}", (Throwable)wsException);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Exception occured while making winrm call", e.initCause((Throwable)wsException));
                    }
                } else {
                    throw new IllegalStateException("Failure when calling " + method + args, e);
                }
                exceptions.add(wsException);
                continue;
            }
        }
        throw new RuntimeException("failed task " + method.getName(), (Throwable)exceptions.get(0));
    }

    @Deprecated
    public void setRetriesForConnectionFailures(int retries) {
        this.retriesForConnectionFailures = retries;
    }
}

