/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.core;

import java.io.IOException;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;

public final class SpringCloudClientConfiguration {
    private static final String PROPERTIES_FILE_LOCATION = "/io/awspring/cloud/core/SpringCloudClientConfiguration.properties";
    private static final String NAME = "spring-cloud-aws";
    private final String version;
    private final ClientOverrideConfiguration clientOverrideConfiguration;

    public SpringCloudClientConfiguration(String version) {
        this.version = version;
        this.clientOverrideConfiguration = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_SUFFIX, (Object)this.getUserAgent()).build();
    }

    public SpringCloudClientConfiguration() {
        this(SpringCloudClientConfiguration.loadVersion());
    }

    private static String loadVersion() {
        try {
            Properties properties = PropertiesLoaderUtils.loadProperties((Resource)new ClassPathResource(PROPERTIES_FILE_LOCATION));
            return properties.getProperty("build.version");
        }
        catch (IOException e) {
            throw new IllegalStateException("Error when loading properties from /io/awspring/cloud/core/SpringCloudClientConfiguration.properties for resolving Spring Cloud AWS version.", e);
        }
    }

    public ClientOverrideConfiguration clientOverrideConfiguration() {
        return this.clientOverrideConfiguration;
    }

    private String getUserAgent() {
        return "spring-cloud-aws/" + this.version;
    }
}

