/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.service.workitem;

import io.automatiko.engine.api.Application;
import io.automatiko.engine.api.auth.IdentityProvider;
import io.automatiko.engine.api.auth.TrustedIdentityProvider;
import io.automatiko.engine.api.runtime.process.WorkItem;
import io.automatiko.engine.api.runtime.process.WorkItemManager;
import io.automatiko.engine.api.uow.UnitOfWorkManager;
import io.automatiko.engine.api.uow.WorkUnit;
import io.automatiko.engine.api.workflow.Process;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.api.workflow.workitem.Policy;
import io.automatiko.engine.api.workflow.workitem.WorkItemExecutionManager;
import io.automatiko.engine.services.uow.UnitOfWorkExecutor;
import io.automatiko.engine.services.utils.StringUtils;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultWorkItemExecutionManager
implements WorkItemExecutionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkItemExecutionManager.class);
    private Map<String, Process<?>> processData = new LinkedHashMap();
    private Application application;

    @Inject
    public DefaultWorkItemExecutionManager(Application application, Instance<Process<?>> availableProcesses) {
        this.processData = availableProcesses == null ? Collections.emptyMap() : availableProcesses.stream().collect(Collectors.toMap(p -> p.id(), p -> p));
        this.application = application;
    }

    public void complete(String processId, String name, WorkItem workItem, WorkItemManager manager, Object source, Function<Throwable, Throwable> errorMapper) {
        if (source instanceof CompletionStage) {
            this.application.unitOfWorkManager().currentUnitOfWork().intercept(this.create(Uni.createFrom().completionStage((CompletionStage)source), processId, name, workItem, manager, errorMapper));
        } else if (source instanceof Uni) {
            this.application.unitOfWorkManager().currentUnitOfWork().intercept(this.create((Uni)source, processId, name, workItem, manager, errorMapper));
        } else {
            manager.completeWorkItem(workItem.getId(), name == null ? null : Collections.singletonMap(name, source), new Policy[0]);
        }
    }

    protected void success(String processId, String name, WorkItem workItem, WorkItemManager manager, Object value) {
        LOGGER.debug("Executing success callback after work item execution");
        Process<?> process = this.processData.get(processId);
        if (process == null) {
            LOGGER.error("Unable to find process with id {}, completion of service invocation aborted", (Object)processId);
            return;
        }
        IdentityProvider.set((IdentityProvider)new TrustedIdentityProvider("System<async>"));
        UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            String id = StringUtils.isEmpty((CharSequence)workItem.getParentProcessInstanceId()) ? workItem.getProcessInstanceId() : workItem.getParentProcessInstanceId() + ":" + workItem.getProcessInstanceId();
            Optional instance = process.instances().findById(id);
            if (instance.isPresent()) {
                ((ProcessInstance)instance.get()).completeWorkItem(workItem.getId(), name == null ? null : Collections.singletonMap(name, value), new Policy[0]);
            }
            return null;
        });
    }

    protected void error(String processId, WorkItem workItem, WorkItemManager manager, Throwable error) {
        LOGGER.debug("Executing error callback after work item execution");
        Process<?> process = this.processData.get(processId);
        if (process == null) {
            LOGGER.error("Unable to find process with id {}, completion of service invocation aborted", (Object)processId);
            return;
        }
        try {
            IdentityProvider.set((IdentityProvider)new TrustedIdentityProvider("System<async>"));
            UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                String id = StringUtils.isEmpty((CharSequence)workItem.getParentProcessInstanceId()) ? workItem.getProcessInstanceId() : workItem.getParentProcessInstanceId() + ":" + workItem.getProcessInstanceId();
                Optional instance = process.instances().findById(id);
                if (instance.isPresent()) {
                    ((ProcessInstance)instance.get()).failWorkItem(workItem.getId(), error);
                }
                return null;
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private WorkUnit<Uni<?>> create(final Uni<?> data, final String processId, final String name, final WorkItem workItem, final WorkItemManager manager, final Function<Throwable, Throwable> errorMapper) {
        return new WorkUnit<Uni<?>>(){

            public Uni<?> data() {
                return data;
            }

            public void perform() {
                this.data().subscribe().with(v -> DefaultWorkItemExecutionManager.this.success(processId, name, workItem, manager, v), err -> DefaultWorkItemExecutionManager.this.error(processId, workItem, manager, (Throwable)errorMapper.apply(err)));
            }

            public Integer priority() {
                return 50000;
            }
        };
    }
}

