/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.service.tracing;

import io.automatiko.engine.api.runtime.process.ProcessInstance;
import io.automatiko.engine.api.runtime.process.WorkflowProcessInstance;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.stream.Collectors;

@ApplicationScoped
public class TracingAdds {
    @Inject
    Instance<Tracer> tracer;

    public void addTags(io.automatiko.engine.api.workflow.ProcessInstance<?> instance) {
        if (this.tracer.isResolvable()) {
            Collection tags;
            Span.current().setAttribute("workflow.instance.id", instance.id());
            Span.current().setAttribute("workflow.root.instance.id", instance.rootProcessInstanceId() == null ? instance.id() : instance.rootProcessInstanceId());
            if (instance.businessKey() != null) {
                Span.current().setAttribute("workflow.business.key", instance.businessKey());
            }
            if (!(tags = instance.tags().values()).isEmpty()) {
                Span.current().setAttribute("workflow.instance.tags", tags.stream().collect(Collectors.joining(",")));
            }
        }
    }

    public void addTags(ProcessInstance instance) {
        if (this.tracer.isResolvable()) {
            Collection tags;
            Span.current().setAttribute("workflow.instance.id", instance.getId());
            Span.current().setAttribute("workflow.root.instance.id", instance.getRootProcessInstanceId() == null ? instance.getId() : instance.getRootProcessInstanceId());
            if (instance.getCorrelationKey() != null) {
                Span.current().setAttribute("workflow.business.key", instance.getCorrelationKey());
            }
            if (!(tags = ((WorkflowProcessInstance)instance).getTags()).isEmpty()) {
                Span.current().setAttribute("workflow.instance.tags", tags.stream().map(t -> t.getValue()).collect(Collectors.joining(",")));
            }
        }
    }
}

