/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.service.rest;

import io.automatiko.engine.api.workflow.HandledServiceExecutionError;
import io.automatiko.engine.api.workflow.workitem.WorkItemExecutionError;
import io.automatiko.engine.services.utils.IoUtils;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class WebErrorMapper
implements Function<Throwable, Throwable> {
    private Set<String> handledCodes = new HashSet<String>();

    public WebErrorMapper(String ... codes) {
        Stream.of(codes).forEach(code -> this.handledCodes.add((String)code));
    }

    @Override
    public Throwable apply(Throwable error) {
        if (error instanceof WorkItemExecutionError) {
            String errorCode = ((WorkItemExecutionError)error).getErrorCode();
            if (this.handledCodes.contains(errorCode)) {
                return new HandledServiceExecutionError((WorkItemExecutionError)error);
            }
        } else {
            if (error instanceof WebApplicationException) {
                WebApplicationException wex = (WebApplicationException)error;
                return new WorkItemExecutionError(wex.getMessage(), String.valueOf(wex.getResponse().getStatus()), IoUtils.valueOf((Object)wex.getResponse().getEntity()));
            }
            if (error instanceof ProcessingException) {
                ProcessingException ex = (ProcessingException)error;
                return new WorkItemExecutionError("503", ex.getMessage(), (Throwable)ex);
            }
        }
        return error;
    }
}

