/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.service.auth;

import io.automatiko.engine.api.auth.IdentityProvider;
import io.automatiko.engine.api.auth.IdentitySupplier;
import io.automatiko.engine.services.identity.StaticIdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class SecuredIdentitySupplier
implements IdentitySupplier {
    @Inject
    Instance<SecurityIdentity> securityInstance;
    @ConfigProperty(name="quarkus.automatiko.security.authorized-only")
    Optional<Boolean> authroizedOnly;
    @ConfigProperty(name="quarkus.automatiko.security.admin-role-name")
    Optional<String> adminRoleName;

    public IdentityProvider buildIdentityProvider(String user, List<String> roles) {
        if (IdentityProvider.isSet()) {
            return IdentityProvider.get();
        }
        Principal principal = this.retrievePrincipal();
        if (this.securityInstance.isUnsatisfied() || principal == null) {
            StaticIdentityProvider current = new StaticIdentityProvider(this.adminRoleName.orElse("admin"), user, roles);
            IdentityProvider.set((IdentityProvider)current);
            return current;
        }
        String principalName = principal.getName();
        if (!this.authroizedOnly.orElse(true).booleanValue() && user != null) {
            principalName = user;
        }
        StaticIdentityProvider current = new StaticIdentityProvider(this.adminRoleName.orElse("admin"), principalName, this.mergeRoles((SecurityIdentity)this.securityInstance.get(), roles), ((SecurityIdentity)this.securityInstance.get()).getAttributes());
        IdentityProvider.set((IdentityProvider)current);
        return current;
    }

    protected List<String> mergeRoles(SecurityIdentity securityIdentity, List<String> roles) {
        if (!this.authroizedOnly.orElse(true).booleanValue() && roles != null) {
            ArrayList<String> merged = new ArrayList<String>(securityIdentity.getRoles());
            merged.addAll(roles);
            return merged;
        }
        return new ArrayList<String>(securityIdentity.getRoles());
    }

    protected Principal retrievePrincipal() {
        if (this.securityInstance.isUnsatisfied()) {
            return null;
        }
        try {
            return ((SecurityIdentity)this.securityInstance.get()).getPrincipal();
        }
        catch (ContextNotActiveException | IllegalStateException e) {
            return null;
        }
    }
}

