/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.service.auth;

import io.automatiko.engine.api.auth.AccessPolicy;
import io.automatiko.engine.api.auth.NamedAccessPolicy;
import io.automatiko.engine.api.workflow.ProcessInstance;
import io.automatiko.engine.workflow.auth.AccessPolicyFactory;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class AccessPolicyRegister {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessPolicyRegister.class);
    private Instance<NamedAccessPolicy<ProcessInstance<?>>> accessPolicies;

    public AccessPolicyRegister() {
    }

    @Inject
    public AccessPolicyRegister(Instance<NamedAccessPolicy<ProcessInstance<?>>> accessPolicies) {
        this.accessPolicies = accessPolicies;
    }

    public void registerAvailablePolicies(@Observes @Priority(value=1000) StartupEvent event) {
        for (NamedAccessPolicy policy : this.accessPolicies) {
            AccessPolicyFactory.register((String)policy.identifier(), (AccessPolicy)policy);
            LOGGER.info("Registering access policy {} with identifer '{}'", (Object)policy, (Object)policy.identifier());
        }
    }

    public void unregisterAvailablePolicies(@Observes ShutdownEvent event) {
        for (NamedAccessPolicy policy : this.accessPolicies) {
            AccessPolicyFactory.unregister((String)policy.identifier());
            LOGGER.info("Unregistering access policy with identifer '{}'", (Object)policy.identifier());
        }
    }
}

