/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.quarkus.encrypt;

import io.automatiko.engine.api.workflow.encrypt.StoredDataCodec;
import io.quarkus.arc.properties.IfBuildProperty;
import jakarta.enterprise.context.ApplicationScoped;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@IfBuildProperty(name="quarkus.automatiko.persistence.encryption", stringValue="aes")
@ApplicationScoped
public class AESStoredDataCodec
implements StoredDataCodec {
    private final Cipher encodeCipher;
    private final Cipher decodeCipher;

    public AESStoredDataCodec(@ConfigProperty(name="automatiko.encryption.aes.key") String key) {
        try {
            SecretKeySpec aesKey = new SecretKeySpec(key.getBytes(), "AES");
            this.encodeCipher = Cipher.getInstance("AES");
            this.decodeCipher = Cipher.getInstance("AES");
            this.encodeCipher.init(1, aesKey);
            this.decodeCipher.init(2, aesKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to intialize ciphers", e);
        }
    }

    public byte[] encode(byte[] data) {
        try {
            return this.encodeCipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Unable to use AES encryption to encode data", e);
        }
    }

    public byte[] decode(byte[] data) {
        try {
            return this.decodeCipher.doFinal(data);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new RuntimeException("Unable to use AES encryption to decode data", e);
        }
    }
}

