/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.quarkus.config;

import io.automatiko.engine.api.codegen.AutomatikoConfigProperties;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class AutomatikoConfigSource
implements ConfigSource {
    public static final String NAME = "AutomatikoConfigSource";
    private List<AutomatikoConfigProperties> found = null;

    public Map<String, String> getProperties() {
        this.load();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        if (this.found == null) {
            return properties;
        }
        for (AutomatikoConfigProperties p : this.found) {
            if (p.getProperties() == null) continue;
            properties.putAll(p.getProperties());
        }
        return properties;
    }

    public String getValue(String propertyName) {
        this.load();
        if (this.found == null) {
            return null;
        }
        return this.found.stream().map(p -> p.getProperty(propertyName)).filter(v -> v != null).findFirst().orElse(null);
    }

    public String getName() {
        return NAME;
    }

    private synchronized void load() {
        if (this.found == null) {
            try {
                ServiceLoader<AutomatikoConfigProperties> loader = ServiceLoader.load(AutomatikoConfigProperties.class);
                List tmp = StreamSupport.stream(loader.spliterator(), false).collect(Collectors.toList());
                tmp.add(new AutomatikoConfigProperties(){
                    private Map<String, String> values = new LinkedHashMap<String, String>();

                    public String getProperty(String name) {
                        if ("mp.openapi.extensions.smallrye.operationIdStrategy".equals(name)) {
                            return "CLASS_METHOD";
                        }
                        return null;
                    }

                    public Map<String, String> getProperties() {
                        if (this.values.isEmpty()) {
                            this.values.put("mp.openapi.extensions.smallrye.operationIdStrategy", "CLASS_METHOD");
                        }
                        return this.values;
                    }
                });
                this.found = tmp;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Set<String> getPropertyNames() {
        this.load();
        if (this.found == null) {
            return Collections.emptySet();
        }
        return this.found.stream().flatMap(c -> c.getProperties().keySet().stream()).collect(Collectors.toSet());
    }
}

