/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.quarkus.audit;

import io.automatiko.engine.api.Application;
import io.automatiko.engine.api.audit.AuditEntry;
import io.automatiko.engine.api.audit.AuditEntryFilter;
import io.automatiko.engine.api.audit.AuditStore;
import io.automatiko.engine.api.audit.Auditor;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class AuditorImpl
implements Auditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditorImpl.class);
    private AuditStore store;
    private Application application;
    private AuditEntryFilter filter;
    private boolean enabled;
    private String format;
    private Set<String> includedTypes = new HashSet<String>();
    private Set<String> excludedTypes = new HashSet<String>();

    @Inject
    public AuditorImpl(AuditStore store, Application application, AuditEntryFilter filter, @ConfigProperty(name="quarkus.automatiko.audit.enabled") Optional<Boolean> enabled, @ConfigProperty(name="quarkus.automatiko.audit.format") Optional<String> format, @ConfigProperty(name="quarkus.automatiko.audit.included") Optional<String> includes, @ConfigProperty(name="quarkus.automatiko.audit.excluded") Optional<String> excludes) {
        this.store = store;
        this.enabled = enabled.orElse(false);
        this.application = application;
        this.filter = filter;
        this.format = format.orElse("plain");
        if (includes.isPresent()) {
            for (String included : includes.get().split(",")) {
                this.includedTypes.add(included.trim().toLowerCase());
            }
        }
        if (excludes.isPresent()) {
            for (String excluded : excludes.get().split(",")) {
                this.excludedTypes.add(excluded.trim().toLowerCase());
            }
        }
    }

    public void publish(Supplier<AuditEntry> entry) {
        if (!this.enabled) {
            return;
        }
        AuditEntry auditEntry = entry.get();
        if (this.excludedTypes.contains(auditEntry.type().name().toLowerCase())) {
            return;
        }
        if (this.includedTypes.isEmpty() || this.includedTypes.contains(auditEntry.type().name().toLowerCase())) {
            try {
                if (!this.filter.accept(auditEntry)) {
                    LOGGER.debug("Audit entry {} has been rejected by configured filter", (Object)auditEntry);
                    return;
                }
                String uowIdentifier = this.application.unitOfWorkManager().currentUnitOfWork().identifier();
                auditEntry.add("transactionId", (Object)uowIdentifier);
                this.store.store(auditEntry, this.format);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to store audit entry due to unexpected error", (Throwable)e);
            }
        }
    }
}

