/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.quarkus.audit;

import io.automatiko.engine.api.audit.AuditEntry;
import io.automatiko.engine.api.audit.Auditor;
import io.automatiko.engine.api.event.process.DefaultProcessEventListener;
import io.automatiko.engine.api.event.process.ProcessCompletedEvent;
import io.automatiko.engine.api.event.process.ProcessNodeInstanceFailedEvent;
import io.automatiko.engine.api.event.process.ProcessNodeLeftEvent;
import io.automatiko.engine.api.event.process.ProcessNodeTriggeredEvent;
import io.automatiko.engine.api.event.process.ProcessSignaledEvent;
import io.automatiko.engine.api.event.process.ProcessStartedEvent;
import io.automatiko.engine.api.event.process.ProcessVariableChangedEvent;
import io.automatiko.engine.api.runtime.process.NodeInstance;
import io.automatiko.engine.api.runtime.process.ProcessInstance;
import io.automatiko.engine.workflow.audit.BaseAuditEntry;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.function.Supplier;

@ApplicationScoped
public class AuditProcessEventListener
extends DefaultProcessEventListener {
    private Auditor auditor;

    @Inject
    public AuditProcessEventListener(Auditor auditor) {
        this.auditor = auditor;
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        Supplier<AuditEntry> entry = () -> BaseAuditEntry.workflow((ProcessInstance)event.getProcessInstance()).add("message", (Object)"Workflow instance started");
        this.auditor.publish(entry);
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        Supplier<AuditEntry> entry = () -> BaseAuditEntry.workflow((ProcessInstance)event.getProcessInstance()).add("message", (Object)"Workflow instance finished");
        this.auditor.publish(entry);
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        Supplier<AuditEntry> entry = () -> BaseAuditEntry.workflow((ProcessInstance)event.getProcessInstance(), (NodeInstance)event.getNodeInstance()).add("message", (Object)"About to execute workflow instance node");
        this.auditor.publish(entry);
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
        Supplier<AuditEntry> entry = () -> BaseAuditEntry.workflow((ProcessInstance)event.getProcessInstance(), (NodeInstance)event.getNodeInstance()).add("message", (Object)"Workflow instance node executed");
        this.auditor.publish(entry);
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        Supplier<AuditEntry> entry = () -> BaseAuditEntry.workflow((ProcessInstance)event.getProcessInstance(), (NodeInstance)event.getNodeInstance(), (String)event.getVariableId()).add("message", (Object)"Workflow instance variable changed").add("variablePreviousValue", event.getOldValue()).add("variableValue", event.getNewValue()).add("variableTags", (Object)event.getTags());
        this.auditor.publish(entry);
    }

    public void afterNodeInstanceFailed(ProcessNodeInstanceFailedEvent event) {
        Supplier<AuditEntry> entry = () -> BaseAuditEntry.workflow((ProcessInstance)event.getProcessInstance(), (NodeInstance)event.getNodeInstance()).add("message", (Object)"Workflow instance node failed").add("errorId", (Object)event.getErrorId()).add("errorMessage", (Object)event.getErrorMessage());
        this.auditor.publish(entry);
    }

    public void beforeProcessSignaled(ProcessSignaledEvent event) {
        Supplier<AuditEntry> entry = () -> BaseAuditEntry.workflow((ProcessInstance)event.getProcessInstance()).add("message", (Object)"About to signal workflow instance").add("signalName", (Object)event.getSignal()).add("signalData", event.getData());
        this.auditor.publish(entry);
    }

    public void afterProcessSignaled(ProcessSignaledEvent event) {
        Supplier<AuditEntry> entry = () -> BaseAuditEntry.workflow((ProcessInstance)event.getProcessInstance()).add("message", (Object)"Workflow instance signaled").add("signalName", (Object)event.getSignal()).add("signalData", event.getData());
        this.auditor.publish(entry);
    }
}

