/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.quarkus;

import io.automatiko.engine.api.workflow.ArchiveStore;
import io.automatiko.engine.api.workflow.EndOfInstanceStrategy;
import io.automatiko.engine.workflow.base.instance.impl.end.ArchiveEndOfInstanceStrategy;
import io.automatiko.engine.workflow.base.instance.impl.end.KeepEndOfInstanceStrategy;
import io.automatiko.engine.workflow.base.instance.impl.end.RemoveEndOfInstanceStrategy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class EndOfInstanceStrategyProducer {
    @Produces
    public EndOfInstanceStrategy produce(@ConfigProperty(name="quarkus.automatiko.on-instance-end", defaultValue="REMOVE") String type, Instance<ArchiveStore> storage) {
        EndOfInstanceStrategy.Type strategyType = EndOfInstanceStrategy.Type.valueOf((String)type.toUpperCase());
        RemoveEndOfInstanceStrategy strategy = null;
        switch (strategyType) {
            case REMOVE: {
                strategy = new RemoveEndOfInstanceStrategy();
                break;
            }
            case KEEP: {
                strategy = new KeepEndOfInstanceStrategy();
                break;
            }
            case ARCHIVE: {
                strategy = new ArchiveEndOfInstanceStrategy((ArchiveStore)storage.get());
                break;
            }
        }
        return strategy;
    }
}

