/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.engine.addons.services.email;

import io.automatiko.engine.api.workflow.ServiceExecutionError;
import io.automatiko.engine.api.workflow.files.File;
import io.automatiko.engine.services.utils.EmailUtils;
import io.quarkus.mailer.Mail;
import io.quarkus.mailer.Mailer;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Template;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class SendEmailService {
    private Mailer mailer;
    private Engine engine;
    private Optional<String> host;

    public SendEmailService() {
    }

    @Inject
    public SendEmailService(Mailer mailer, Engine engine, @ConfigProperty(name="quarkus.mailer.host") Optional<String> host) {
        this.mailer = mailer;
        this.engine = engine;
        this.host = host;
    }

    public void sendSimple(String tos, String subject, String body, File<byte[]> ... attachments) {
        try {
            for (String to : tos.split(",")) {
                Mail mail = Mail.withHtml((String)to, (String)subject, (String)body);
                for (File<byte[]> attachment : attachments) {
                    if (attachment == null) continue;
                    mail.addAttachment(attachment.name(), (byte[])attachment.content(), attachment.type());
                }
                this.mailer.send(new Mail[]{mail});
            }
        }
        catch (Exception e) {
            throw new ServiceExecutionError("sendEmailFailure", e.getMessage(), (Throwable)e);
        }
    }

    public void sendSimpleCorrelated(String correlation, String tos, String subject, String body, File<byte[]> ... attachments) {
        try {
            for (String to : tos.split(",")) {
                Mail mail = Mail.withHtml((String)to, (String)subject, (String)body);
                for (File<byte[]> attachment : attachments) {
                    if (attachment == null) continue;
                    mail.addAttachment(attachment.name(), (byte[])attachment.content(), attachment.type());
                }
                mail.addHeader("Message-ID", new String[]{EmailUtils.messageIdWithCorrelation((String)correlation, (String)this.host.orElse("localhost"))});
                this.mailer.send(new Mail[]{mail});
            }
        }
        catch (Exception e) {
            throw new ServiceExecutionError("sendEmailFailure", e.getMessage(), (Throwable)e);
        }
    }

    public void sendSimpleWithCC(String tos, String ccs, String subject, String body, File<byte[]> ... attachments) {
        try {
            for (String to : tos.split(",")) {
                Mail mail = Mail.withHtml((String)to, (String)subject, (String)body);
                for (String string : ccs.split(",")) {
                    mail.addCc(new String[]{string});
                }
                for (String string : attachments) {
                    if (string == null) continue;
                    mail.addAttachment(string.name(), (byte[])string.content(), string.type());
                }
                this.mailer.send(new Mail[]{mail});
            }
        }
        catch (Exception e) {
            throw new ServiceExecutionError("sendEmailFailure", e.getMessage(), (Throwable)e);
        }
    }

    public void sendSimpleWithBCC(String tos, String bccs, String subject, String body, File<byte[]> ... attachments) {
        try {
            for (String to : tos.split(",")) {
                Mail mail = Mail.withHtml((String)to, (String)subject, (String)body);
                for (String string : bccs.split(",")) {
                    mail.addBcc(new String[]{string});
                }
                for (String string : attachments) {
                    if (string == null) continue;
                    mail.addAttachment(string.name(), (byte[])string.content(), string.type());
                }
                this.mailer.send(new Mail[]{mail});
            }
        }
        catch (Exception e) {
            throw new ServiceExecutionError("sendEmailFailure", e.getMessage(), (Throwable)e);
        }
    }

    public void sendSimpleCorrelatedWithCC(String correlation, String tos, String ccs, String subject, String body, File<byte[]> ... attachments) {
        try {
            for (String to : tos.split(",")) {
                Mail mail = Mail.withHtml((String)to, (String)subject, (String)body);
                for (String string : ccs.split(",")) {
                    mail.addCc(new String[]{string});
                }
                for (String string : attachments) {
                    if (string == null) continue;
                    mail.addAttachment(string.name(), (byte[])string.content(), string.type());
                }
                mail.addHeader("Message-ID", new String[]{EmailUtils.messageIdWithCorrelation((String)correlation, (String)this.host.orElse("localhost"))});
                this.mailer.send(new Mail[]{mail});
            }
        }
        catch (Exception e) {
            throw new ServiceExecutionError("sendEmailFailure", e.getMessage(), (Throwable)e);
        }
    }

    public void sendSimpleCorrelatedWithBCC(String correlation, String tos, String bccs, String subject, String body, File<byte[]> ... attachments) {
        try {
            for (String to : tos.split(",")) {
                Mail mail = Mail.withHtml((String)to, (String)subject, (String)body);
                for (String string : bccs.split(",")) {
                    mail.addBcc(new String[]{string});
                }
                for (String string : attachments) {
                    if (string == null) continue;
                    mail.addAttachment(string.name(), (byte[])string.content(), string.type());
                }
                mail.addHeader("Message-ID", new String[]{EmailUtils.messageIdWithCorrelation((String)correlation, (String)this.host.orElse("localhost"))});
                this.mailer.send(new Mail[]{mail});
            }
        }
        catch (Exception e) {
            throw new ServiceExecutionError("sendEmailFailure", e.getMessage(), (Throwable)e);
        }
    }

    public void send(String tos, String subject, String templateName, Object body, File<byte[]> ... attachments) {
        Template template = this.getTemplate(templateName);
        try {
            HashMap<String, Object> templateData = new HashMap<String, Object>();
            templateData.put("body", body);
            String content = template.instance().data(templateData).render();
            for (String to : tos.split(",")) {
                Mail mail = Mail.withHtml((String)to, (String)subject, (String)content);
                for (File<byte[]> attachment : attachments) {
                    if (attachment == null) continue;
                    mail.addAttachment(attachment.name(), (byte[])attachment.content(), attachment.type());
                }
                this.mailer.send(new Mail[]{mail});
            }
        }
        catch (Exception e) {
            throw new ServiceExecutionError("sendEmailFailure", e.getMessage(), (Throwable)e);
        }
    }

    public void sendCorrelated(String correlation, String tos, String subject, String templateName, Object body, File<byte[]> ... attachments) {
        Template template = this.getTemplate(templateName);
        try {
            HashMap<String, Object> templateData = new HashMap<String, Object>();
            templateData.put("body", body);
            String content = template.instance().data(templateData).render();
            for (String to : tos.split(",")) {
                Mail mail = Mail.withHtml((String)to, (String)subject, (String)content);
                for (File<byte[]> attachment : attachments) {
                    if (attachment == null) continue;
                    mail.addAttachment(attachment.name(), (byte[])attachment.content(), attachment.type());
                }
                mail.addHeader("Message-ID", new String[]{EmailUtils.messageIdWithCorrelation((String)correlation, (String)this.host.orElse("localhost"))});
                this.mailer.send(new Mail[]{mail});
            }
        }
        catch (Exception e) {
            throw new ServiceExecutionError("sendEmailFailure", e.getMessage(), (Throwable)e);
        }
    }

    public void sendWithCC(String tos, String ccs, String subject, String templateName, Object body, File<byte[]> ... attachments) {
        Template template = this.getTemplate(templateName);
        try {
            HashMap<String, Object> templateData = new HashMap<String, Object>();
            templateData.put("body", body);
            String content = template.instance().data(templateData).render();
            for (String to : tos.split(",")) {
                Mail mail = Mail.withHtml((String)to, (String)subject, (String)content);
                for (String string : ccs.split(",")) {
                    mail.addCc(new String[]{string});
                }
                for (String string : attachments) {
                    if (string == null) continue;
                    mail.addAttachment(string.name(), (byte[])string.content(), string.type());
                }
                this.mailer.send(new Mail[]{mail});
            }
        }
        catch (Exception e) {
            throw new ServiceExecutionError("sendEmailFailure", e.getMessage(), (Throwable)e);
        }
    }

    public void sendWithBCC(String tos, String bccs, String subject, String templateName, Object body, File<byte[]> ... attachments) {
        Template template = this.getTemplate(templateName);
        try {
            HashMap<String, Object> templateData = new HashMap<String, Object>();
            templateData.put("body", body);
            String content = template.instance().data(templateData).render();
            for (String to : tos.split(",")) {
                Mail mail = Mail.withHtml((String)to, (String)subject, (String)content);
                for (String string : bccs.split(",")) {
                    mail.addBcc(new String[]{string});
                }
                for (String string : attachments) {
                    if (string == null) continue;
                    mail.addAttachment(string.name(), (byte[])string.content(), string.type());
                }
                this.mailer.send(new Mail[]{mail});
            }
        }
        catch (Exception e) {
            throw new ServiceExecutionError("sendEmailFailure", e.getMessage(), (Throwable)e);
        }
    }

    public void sendCorrelatedWithCC(String correlation, String tos, String ccs, String subject, String templateName, Object body, File<byte[]> ... attachments) {
        Template template = this.getTemplate(templateName);
        try {
            HashMap<String, Object> templateData = new HashMap<String, Object>();
            templateData.put("body", body);
            String content = template.instance().data(templateData).render();
            for (String to : tos.split(",")) {
                Mail mail = Mail.withHtml((String)to, (String)subject, (String)content);
                for (String string : ccs.split(",")) {
                    mail.addCc(new String[]{string});
                }
                for (String string : attachments) {
                    if (string == null) continue;
                    mail.addAttachment(string.name(), (byte[])string.content(), string.type());
                }
                mail.addHeader("Message-ID", new String[]{EmailUtils.messageIdWithCorrelation((String)correlation, (String)this.host.orElse("localhost"))});
                this.mailer.send(new Mail[]{mail});
            }
        }
        catch (Exception e) {
            throw new ServiceExecutionError("sendEmailFailure", e.getMessage(), (Throwable)e);
        }
    }

    public void sendCorrelatedWithBCC(String correlation, String tos, String bccs, String subject, String templateName, Object body, File<byte[]> ... attachments) {
        Template template = this.getTemplate(templateName);
        try {
            HashMap<String, Object> templateData = new HashMap<String, Object>();
            templateData.put("body", body);
            String content = template.instance().data(templateData).render();
            for (String to : tos.split(",")) {
                Mail mail = Mail.withHtml((String)to, (String)subject, (String)content);
                for (String string : bccs.split(",")) {
                    mail.addBcc(new String[]{string});
                }
                for (String string : attachments) {
                    if (string == null) continue;
                    mail.addAttachment(string.name(), (byte[])string.content(), string.type());
                }
                mail.addHeader("Message-ID", new String[]{EmailUtils.messageIdWithCorrelation((String)correlation, (String)this.host.orElse("localhost"))});
                this.mailer.send(new Mail[]{mail});
            }
        }
        catch (Exception e) {
            throw new ServiceExecutionError("sendEmailFailure", e.getMessage(), (Throwable)e);
        }
    }

    protected Template getTemplate(String name) {
        Template template = this.engine.getTemplate(name);
        if (template == null) {
            throw new ServiceExecutionError("emailTemplateNotFound", "Email template '" + name + "' not found");
        }
        return template;
    }
}

