/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addons.usertasks.index.db;

import io.automatiko.addon.usertasks.index.UserTask;
import io.automatiko.addon.usertasks.index.UserTaskIndexResource;
import io.automatiko.addons.usertasks.index.db.DbCustomQueryBuilder;
import io.automatiko.addons.usertasks.index.db.DbQueryFilter;
import io.automatiko.addons.usertasks.index.db.UserTaskInfoEntity;
import io.automatiko.engine.api.auth.IdentityProvider;
import io.automatiko.engine.api.auth.IdentitySupplier;
import io.automatiko.engine.api.workflow.workitem.NotAuthorizedException;
import io.quarkus.arc.All;
import io.quarkus.panache.common.Sort;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ApplicationScoped
public class DBUserTaskIndexResource
implements UserTaskIndexResource {
    private IdentitySupplier identitySupplier;
    private Map<String, DbCustomQueryBuilder> customQueries = new HashMap<String, DbCustomQueryBuilder>();

    @Inject
    public DBUserTaskIndexResource(IdentitySupplier identitySupplier, @All List<DbCustomQueryBuilder> queries) {
        this.identitySupplier = identitySupplier;
        queries.stream().forEach(q -> this.customQueries.put(q.id(), (DbCustomQueryBuilder)q));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends UserTask> findTasks(String name, String description, String state, String priority, int page, int size, String sortBy, boolean sortAsc, String user, List<String> groups) {
        IdentityProvider identityProvider = this.identitySupplier.buildIdentityProvider(user, groups);
        if (identityProvider.getName() == null) {
            return Collections.emptyList();
        }
        try {
            Sort sort = null;
            if (sortBy != null) {
                sort = Sort.by((String)this.sortBy(sortBy), (Sort.Direction)(sortAsc ? Sort.Direction.Ascending : Sort.Direction.Descending));
            }
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            StringBuilder builder = new StringBuilder(this.authFilter(identityProvider, parameters));
            if (name != null) {
                builder.append(" t.taskName like :taskName and");
                parameters.put("taskName", "%" + name + " %");
            }
            if (description != null) {
                builder.append(" t.taskDescription like :taskDescription and");
                parameters.put("taskDescription", "%" + description + " %");
            }
            if (state != null) {
                builder.append(" t.state = :state and");
                parameters.put("state", state);
            }
            if (priority != null) {
                builder.append(" t.taskPriority like :taskPriority and");
                parameters.put("taskPriority", priority);
            }
            String query = builder.toString();
            query = query.substring(0, query.length() - 4);
            List list = UserTaskInfoEntity.find((String)query, (Sort)sort, parameters).page(this.calculatePage(page, size), size).list();
            return list;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserTask findTask(String id, String user, List<String> groups) {
        IdentityProvider identityProvider = this.identitySupplier.buildIdentityProvider(user, groups);
        try {
            UserTaskInfoEntity entity = (UserTaskInfoEntity)UserTaskInfoEntity.findById((Object)id);
            try {
                this.enforceAuthorization(entity, identityProvider);
                UserTaskInfoEntity userTaskInfoEntity = entity;
                return userTaskInfoEntity;
            }
            catch (NotAuthorizedException e) {
                UserTask userTask = null;
                IdentityProvider.set(null);
                return userTask;
            }
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends UserTask> queryTasks(UriInfo uriInfo, String name, int page, int size, String sortBy, boolean sortAsc, String user, List<String> groups) {
        DbCustomQueryBuilder customQuery = this.customQueries.get(name);
        if (customQuery == null) {
            throw new NotFoundException("Query with id '" + name + "' was not registered");
        }
        IdentityProvider identityProvider = this.identitySupplier.buildIdentityProvider(user, groups);
        try {
            Sort sort = null;
            if (sortBy != null) {
                sort = Sort.by((String)this.sortBy(sortBy), (Sort.Direction)(sortAsc ? Sort.Direction.Ascending : Sort.Direction.Descending));
            }
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            StringBuilder builder = new StringBuilder(this.authFilter(identityProvider, parameters));
            DbQueryFilter extraFilter = (DbQueryFilter)customQuery.build((Map)uriInfo.getQueryParameters());
            String query = builder.append(" " + extraFilter.queryFilter()).toString();
            parameters.putAll(extraFilter.parameters());
            List list = UserTaskInfoEntity.find((String)query, (Sort)sort, parameters).page(this.calculatePage(page, size), size).list();
            return list;
        }
        finally {
            IdentityProvider.set(null);
        }
    }

    protected String authFilter(IdentityProvider identityProvider, Map<String, Object> parameters) {
        parameters.put("user", identityProvider.getName());
        parameters.put("groups", identityProvider.getRoles());
        String authFilter = "from UserTaskInfoEntity t left join t.potentialUsers pu left join t.potentialGroups pg where (:user not member of t.excludedUsers) and (:user member of t.potentialUsers or pg in (:groups) or t.actualOwner = :user or (size(pg) < 1 and size(pu) < 1)) and ";
        return authFilter;
    }

    protected void enforceAuthorization(UserTaskInfoEntity entity, IdentityProvider identity) {
        if (identity != null) {
            String user = identity.getName();
            String currentOwner = entity.getActualOwner();
            if (currentOwner != null && !currentOwner.trim().isEmpty() && !user.equals(currentOwner)) {
                throw new NotAuthorizedException("User " + user + " is not authorized to access task instance with id " + entity.getId());
            }
            this.checkAssignedOwners(entity, user, identity);
        }
    }

    protected void checkAssignedOwners(UserTaskInfoEntity entity, String user, IdentityProvider identity) {
        if (entity.getExcludedUsers().contains(user)) {
            throw new NotAuthorizedException("User " + user + " is not authorized to access task instance with id " + entity.getId());
        }
        if (entity.getPotentialUsers().isEmpty() && entity.getPotentialGroups().isEmpty()) {
            return;
        }
        if (!entity.getPotentialUsers().contains(user)) {
            if (entity.getPotentialGroups().stream().noneMatch(arg_0 -> ((IdentityProvider)identity).hasRole(arg_0))) {
                throw new NotAuthorizedException("User " + user + " is not authorized to access task instance with id " + entity.getId());
            }
        }
    }

    protected int calculatePage(int page, int size) {
        if (page <= 1) {
            return 0;
        }
        return (page - 1) * size;
    }

    protected String sortBy(String sortBy) {
        String fieldName = sortBy;
        switch (sortBy) {
            case "name": {
                fieldName = "taskName";
                break;
            }
            case "description": {
                fieldName = "taskDescription";
                break;
            }
            case "priority": {
                fieldName = "taskPriority";
                break;
            }
        }
        return "t." + fieldName;
    }
}

