/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addons.usertasks.index.db;

import io.automatiko.addon.usertasks.index.UserTask;
import io.automatiko.addons.usertasks.index.db.UserTaskInfoEntity;
import io.automatiko.engine.api.event.DataEvent;
import io.automatiko.engine.api.event.EventPublisher;
import io.automatiko.engine.services.event.UserTaskInstanceDataEvent;
import io.automatiko.engine.services.event.impl.UserTaskInstanceEventBody;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class DBUserTaskEventPublisher
implements EventPublisher {
    private String serviceUrl;
    private boolean keepCompleted;

    @Inject
    public DBUserTaskEventPublisher(@ConfigProperty(name="quarkus.automatiko.service-url") Optional<String> serviceUrl, @ConfigProperty(name="quarkus.automatiko.on-instance-end") Optional<String> onInstanceEnd) {
        this.serviceUrl = serviceUrl.orElse("");
        this.keepCompleted = onInstanceEnd.orElse("remove").equalsIgnoreCase("keep");
    }

    @Transactional
    public void publish(DataEvent<?> event) {
        if (event instanceof UserTaskInstanceDataEvent) {
            UserTaskInstanceDataEvent uevent = (UserTaskInstanceDataEvent)event;
            UserTaskInstanceEventBody data = (UserTaskInstanceEventBody)uevent.getData();
            UserTaskInfoEntity task = new UserTaskInfoEntity();
            task.setId(data.getId());
            task.setTaskName(data.getTaskName());
            task.setTaskDescription(data.getTaskDescription());
            task.setPotentialUsers(this.nullIfEmpty(data.getPotentialUsers()));
            task.setPotentialGroups(this.nullIfEmpty(data.getPotentialGroups()));
            task.setExcludedUsers(this.nullIfEmpty(data.getExcludedUsers()));
            task.setTaskPriority(data.getTaskPriority());
            task.setState(data.getState());
            task.setActualOwner(data.getActualOwner());
            task.setCompleteDate(data.getCompleteDate());
            task.setFormLink(this.serviceUrl + data.getFormLink());
            task.setProcessId(data.getProcessId());
            task.setProcessInstanceId(data.getProcessInstanceId());
            task.setRootProcessId(data.getRootProcessId());
            task.setRootProcessInstanceId(data.getRootProcessInstanceId());
            task.setReferenceId(data.getReferenceId());
            task.setReferenceName(data.getReferenceName());
            task.setStartDate(data.getStartDate());
            if (this.keepCompleted || this.isActive(task)) {
                UserTaskInfoEntity.persist((Object)((Object)task), (Object[])new Object[0]);
            } else {
                UserTaskInfoEntity.deleteById((Object)task.getId());
            }
        }
    }

    public void publish(Collection<DataEvent<?>> events) {
        for (DataEvent<?> event : events) {
            this.publish(event);
        }
    }

    private Set<String> nullIfEmpty(Set<String> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        return set;
    }

    private boolean isActive(UserTask task) {
        return "Ready".equalsIgnoreCase(task.getState()) || "Reserved".equalsIgnoreCase(task.getState()) || "Ready".equalsIgnoreCase(task.getState());
    }
}

