/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addon.files.mongodb.web;

import io.automatiko.addon.files.mongodb.GridFSStore;
import io.automatiko.engine.api.workflow.files.File;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.FileNotFoundException;

@Path(value="/management/files")
public class GridFSDownloadResource {
    private GridFSStore store;

    @Inject
    public GridFSDownloadResource(GridFSStore store) {
        this.store = store;
    }

    @GET
    @Path(value="download/{processId}/{processInstanceId}/{variable}/{filename}")
    @Produces(value={"application/octet-stream"})
    public Response downloadFile(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="variable") String variable, @PathParam(value="filename") String filename) {
        try {
            byte[] content = this.store.content(processId, processInstanceId, variable, filename);
            Response.ResponseBuilder response = Response.ok().entity((Object)content);
            response.header("Content-Disposition", (Object)("attachment;filename=" + filename));
            response.header("Content-Type", (Object)File.discoverType((String)filename));
            return response.build();
        }
        catch (FileNotFoundException e) {
            return Response.status((int)Response.Status.NOT_FOUND.getStatusCode(), (String)("File with name " + filename + " not found")).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="download/{processId}/{processVersion}/{processInstanceId}/{variable}/{filename}")
    @Produces(value={"application/octet-stream"})
    public Response downloadVersionedFile(@PathParam(value="processId") String processId, @PathParam(value="processVersion") String processVersion, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="variable") String variable, @PathParam(value="filename") String filename) {
        try {
            byte[] content = this.store.content(processId, processVersion, processInstanceId, variable, filename);
            Response.ResponseBuilder response = Response.ok().entity((Object)content);
            response.header("Content-Disposition", (Object)("attachment;filename=" + filename));
            response.header("Content-Type", (Object)File.discoverType((String)filename));
            return response.build();
        }
        catch (FileNotFoundException e) {
            return Response.status((int)Response.Status.NOT_FOUND.getStatusCode(), (String)("File with name " + filename + " not found")).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }
}

