/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addon.files.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.Filters;
import io.automatiko.engine.api.workflow.encrypt.StoredDataCodec;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class GridFSStore {
    private String serviceUrl;
    private String database;
    private Integer chunkSize;
    private StoredDataCodec codec;
    private GridFSBucket gridFSBucket;

    @Inject
    public GridFSStore(StoredDataCodec codec, MongoClient mongoClient, @ConfigProperty(name="quarkus.automatiko.files.mongodb.database") Optional<String> database, @ConfigProperty(name="quarkus.automatiko.files.mongodb.chunk-size") Optional<Integer> chunkSize, @ConfigProperty(name="quarkus.automatiko.service-url") Optional<String> serviceUrl) {
        this.codec = codec;
        this.serviceUrl = serviceUrl.orElse("http://localhost:8080") + "/management/files/download/";
        this.database = database.orElse("automatiko");
        this.chunkSize = chunkSize.orElse(0x100000);
        this.gridFSBucket = GridFSBuckets.create((MongoDatabase)mongoClient.getDatabase(this.database));
    }

    public String urlPrefix() {
        return this.serviceUrl;
    }

    public void save(byte[] content, String processId, String processVersion, String processInstanceId, String ... name) {
        Document metadata = new Document("processId", (Object)processId).append("processVersion", (Object)processVersion).append("processInstanceId", (Object)processInstanceId);
        if (name.length >= 2) {
            metadata.append("variable", (Object)name[0]).append("filename", (Object)name[1]);
        }
        try (ByteArrayInputStream streamToUploadFrom = new ByteArrayInputStream(this.codec.encode(content));){
            GridFSUploadOptions options = new GridFSUploadOptions().chunkSizeBytes(this.chunkSize).metadata(metadata);
            String fileId = this.buildId(processId, processVersion, processInstanceId, name);
            this.gridFSBucket.uploadFromStream((BsonValue)new BsonString(fileId), this.buildName(processId, processVersion, processInstanceId, name), (InputStream)streamToUploadFrom, options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void replace(byte[] content, String processId, String processVersion, String processInstanceId, String ... name) {
        this.remove(processId, processVersion, processInstanceId, name);
        this.save(content, processId, processVersion, processInstanceId, name);
    }

    public void remove(String processId, String processVersion, String processInstanceId, String ... name) {
        String fileId = this.buildId(processId, processVersion, processInstanceId, name);
        if (this.gridFSBucket.find(Filters.eq((String)"_id", (Object)fileId)).first() != null) {
            this.gridFSBucket.delete((BsonValue)new BsonString(fileId));
        }
    }

    public byte[] content(String url) {
        String items = url.replaceFirst(this.serviceUrl, "");
        BsonString fileId = new BsonString(UUID.nameUUIDFromBytes(items.getBytes(StandardCharsets.UTF_8)).toString());
        try (GridFSDownloadStream downloadStream = this.gridFSBucket.openDownloadStream((BsonValue)fileId);){
            int fileLength = (int)downloadStream.getGridFSFile().getLength();
            byte[] content = new byte[fileLength];
            downloadStream.read(content);
            byte[] byArray = this.codec.decode(content);
            return byArray;
        }
    }

    public byte[] content(String processId, String processVersion, String processInstanceId, String ... name) throws FileNotFoundException {
        BsonString fileId = new BsonString(this.buildId(processId, processVersion, processInstanceId, name));
        try (GridFSDownloadStream downloadStream = this.gridFSBucket.openDownloadStream((BsonValue)fileId);){
            int fileLength = (int)downloadStream.getGridFSFile().getLength();
            byte[] content = new byte[fileLength];
            downloadStream.read(content);
            byte[] byArray = this.codec.decode(content);
            return byArray;
        }
    }

    protected String buildName(String processId, String processVersion, String processInstanceId, String ... name) {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(processId);
        if (processVersion != null && !processVersion.isEmpty()) {
            elements.add(processVersion);
        }
        elements.add(processInstanceId);
        for (String nameElement : name) {
            elements.add(nameElement);
        }
        return Stream.of((String[])elements.toArray(String[]::new)).collect(Collectors.joining("/"));
    }

    protected String buildId(String processId, String processVersion, String processInstanceId, String ... name) {
        String idAsPath = this.buildName(processId, processVersion, processInstanceId, name);
        return UUID.nameUUIDFromBytes(idAsPath.getBytes(StandardCharsets.UTF_8)).toString();
    }
}

