/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addon.files.mongodb;

import io.automatiko.addon.files.mongodb.GridFSFile;
import io.automatiko.addon.files.mongodb.GridFSStore;
import io.automatiko.engine.api.workflow.Variable;
import io.automatiko.engine.api.workflow.VariableAugmentor;
import io.automatiko.engine.api.workflow.files.HasFiles;
import io.automatiko.engine.workflow.file.ByteArrayFile;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;

@ApplicationScoped
public class GridFSFileVariableAugmentor
implements VariableAugmentor {
    private String serviceUrl;
    private GridFSStore store;

    @Inject
    public GridFSFileVariableAugmentor(GridFSStore store) {
        this.store = store;
        this.serviceUrl = store.urlPrefix();
    }

    public boolean accept(Variable variable, Object value) {
        if (value == null) {
            if (variable.getType().getClassType() != null) {
                return ByteArrayFile.class.isAssignableFrom(variable.getType().getClassType());
            }
            return false;
        }
        if (value instanceof HasFiles) {
            value = ((HasFiles)value).files();
        }
        if (value instanceof ByteArrayFile) {
            return true;
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().anyMatch(item -> item instanceof ByteArrayFile);
        }
        return false;
    }

    public Object augmentOnCreate(String processId, String processVersion, String processInstanceId, Variable variable, Object value) {
        Object originalValue = value;
        if ((value = this.retrieveValue(value)) == null) {
            return value;
        }
        StringBuilder url = new StringBuilder(this.serviceUrl);
        url.append(processId).append("/");
        if (processVersion != null && !processVersion.isEmpty()) {
            url.append(processVersion).append("/");
        }
        url.append(processInstanceId).append("/").append(variable.getName());
        if (value instanceof ByteArrayFile) {
            ByteArrayFile file = (ByteArrayFile)value;
            if (file.content() != null) {
                GridFSFile fsFile = new GridFSFile(file.name(), null, file.attributes());
                fsFile.url(url.toString() + "/" + file.name());
                this.store.save(file.content(), processId, processVersion, processInstanceId, variable.getName(), file.name());
                value = this.updateValue(originalValue, (Object)fsFile);
            }
        } else if (value instanceof Collection) {
            ArrayList<ByteArrayFile> fsFiles = new ArrayList<ByteArrayFile>();
            for (Object potentialFile : (Collection)value) {
                if (!(potentialFile instanceof ByteArrayFile)) continue;
                ByteArrayFile file = (ByteArrayFile)potentialFile;
                if (file.content() != null) {
                    GridFSFile fsFile = new GridFSFile(file.name(), null, file.attributes());
                    fsFile.url(url.toString() + "/" + file.name());
                    this.store.save(file.content(), processId, processVersion, processInstanceId, variable.getName(), file.name());
                    fsFiles.add(fsFile);
                    continue;
                }
                fsFiles.add(file);
            }
            return this.updateValue(originalValue, fsFiles);
        }
        return value;
    }

    public Object augmentOnUpdate(String processId, String processVersion, String processInstanceId, Variable variable, Object value) {
        Object originalValue = value;
        if ((value = this.retrieveValue(value)) == null) {
            return value;
        }
        StringBuilder url = new StringBuilder(this.serviceUrl);
        url.append(processId).append("/");
        if (processVersion != null && !processVersion.isEmpty()) {
            url.append(processVersion).append("/");
        }
        url.append(processInstanceId).append("/").append(variable.getName());
        if (value instanceof ByteArrayFile) {
            ByteArrayFile file = (ByteArrayFile)value;
            if (file.content() != null) {
                GridFSFile fsFile = new GridFSFile(file.name(), null, file.attributes());
                fsFile.url(url.toString() + "/" + file.name());
                this.store.replace(file.content(), processId, processVersion, processInstanceId, variable.getName(), file.name());
                value = this.updateValue(originalValue, (Object)fsFile);
            }
        } else if (value instanceof Collection) {
            ArrayList<ByteArrayFile> fsFiles = new ArrayList<ByteArrayFile>();
            for (Object potentialFile : (Collection)value) {
                if (!(potentialFile instanceof ByteArrayFile)) continue;
                ByteArrayFile file = (ByteArrayFile)potentialFile;
                if (file.content() != null) {
                    GridFSFile fsFile = new GridFSFile(file.name(), null, file.attributes());
                    fsFile.url(url.toString() + "/" + file.name());
                    this.store.replace(file.content(), processId, processVersion, processInstanceId, variable.getName(), file.name());
                    fsFiles.add(fsFile);
                    continue;
                }
                fsFiles.add(file);
            }
            return this.updateValue(originalValue, fsFiles);
        }
        return value;
    }

    public void augmentOnDelete(String processId, String processVersion, String processInstanceId, Variable variable, Object value) {
        if ((value = this.retrieveValue(value)) instanceof ByteArrayFile) {
            ByteArrayFile file = (ByteArrayFile)value;
            this.store.remove(processId, processVersion, processInstanceId, variable.getName(), file.name());
        } else if (value instanceof Collection) {
            for (Object potentialFile : (Collection)value) {
                if (!(potentialFile instanceof ByteArrayFile)) continue;
                ByteArrayFile file = (ByteArrayFile)potentialFile;
                this.store.remove(processId, processVersion, processInstanceId, variable.getName(), file.name());
            }
        }
    }

    protected Object retrieveValue(Object value) {
        if (value instanceof HasFiles) {
            return ((HasFiles)value).files();
        }
        return value;
    }

    protected Object updateValue(Object variable, Object value) {
        if (variable instanceof HasFiles) {
            ((HasFiles)variable).augmentFiles(value);
            return variable;
        }
        return value;
    }
}

