/*
 * Decompiled with CFR 0.152.
 */
package io.automatiko.addon.files.mongodb;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.automatiko.addon.files.mongodb.GridFSStore;
import io.automatiko.engine.workflow.file.ByteArrayFile;
import io.quarkus.arc.Arc;
import java.lang.annotation.Annotation;
import java.util.Map;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public class GridFSFile
extends ByteArrayFile {
    private String url;

    public GridFSFile(String name, byte[] content) {
        super(name, content);
    }

    @JsonCreator
    public GridFSFile(@JsonProperty(value="name") String name, @JsonProperty(value="content") byte[] content, @JsonProperty(value="attributes") Map<String, String> attributes) {
        super(name, content, attributes);
    }

    @JsonGetter
    public String name() {
        return this.name;
    }

    public byte[] content() {
        GridFSStore store;
        if (this.content == null && (store = (GridFSStore)Arc.container().instance(GridFSStore.class, new Annotation[0]).orElse(null)) != null) {
            this.content = store.content(this.url());
        }
        return this.content;
    }

    @JsonGetter
    public Map<String, String> attributes() {
        return this.attributes;
    }

    @JsonGetter
    public String url() {
        return this.url;
    }

    @JsonSetter
    public void url(String url) {
        this.url = url;
    }

    public String toString() {
        return "GridFSFile [name=" + this.name + ", content (url)=" + this.url + ", attributes=" + this.attributes + "]";
    }
}

